% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_mixedBayes.R
\name{predict_mixedBayes}
\alias{predict_mixedBayes}
\title{Make predictions from a mixedBayes object}
\usage{
predict_mixedBayes(object, y, X, e, g, w, k, slope, loss)
}
\arguments{
\item{object}{a mixedBayes object.}

\item{y}{a numeric vector of repeated-measure responses in long format.
The current version only supports continuous response.}

\item{X}{the long-format design matrix, including an intercept and optionally
time-related covariates.}

\item{e}{the long-format design matrix for environment/treatment effects. In applications,
this is a set of dummy variables encoding treatment levels.}

\item{g}{the long-format matrix of genetic predictors.}

\item{w}{the long-format matrix of gene-environment interaction terms.}

\item{k}{integer. Number of repeated measurements per subject.}

\item{slope}{logical flag. If TRUE, random intercept-and-slope model will be used.}

\item{loss}{character string specifying the prediction loss function.
"L1" for mean absolute error;
"L2" for mean squared error.}
}
\value{
an object of class `mixedBayes.pred' is returned, which is a list with components:
\item{pred_error}{prediction error.}
\item{y_hat}{predicted values of the repeated measured responses.}
}
\description{
Make predictions from a mixedBayes object
}
\examples{
data(data)

fit <- mixedBayes(y, e, X, g, w, k, structure = c("bi-level"))
pred1 <- predict_mixedBayes(fit, y, X, e, g, w, k, slope = TRUE, loss = "L1")
print(pred1$pred_error)
pred2 <- predict_mixedBayes(fit, y, X, e, g, w, k, slope = TRUE, loss = "L2")
print(pred2$pred_error)

}
\seealso{
\code{\link{mixedBayes}}
}
