% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ienumerate.R
\name{i_enumerate}
\alias{i_enumerate}
\alias{ienumerate}
\alias{i_enumerate.default}
\alias{i_enum}
\alias{i_enumerate.array}
\title{Iterator that returns the elements of an object along with their indices}
\usage{
i_enumerate(obj, ...)

ienumerate(obj, ...)

\method{i_enumerate}{default}(obj, ..., recycle = FALSE, chunkSize, chunks)

i_enum(obj, ...)

\method{i_enumerate}{array}(
  obj,
  ...,
  recycle = FALSE,
  chunkSize,
  chunks,
  by = c("cell", "row", "column"),
  rowMajor = TRUE,
  drop = FALSE
)
}
\arguments{
\item{obj}{object to return indefinitely.}

\item{...}{Undocumented.}

\item{recycle}{Whether to restart the iterator after finishing the
array.}

\item{chunkSize}{How large a chunk to take along the specified
dimension.}

\item{chunks}{How many chunks to divide the array into.}

\item{by}{Which array margins to iterate over. Can be "row", "col", "cell",
or a vector of numerical indices.}

\item{rowMajor}{If TRUE, the first index varies fastest, if FALSE, the last index varies fastest.}

\item{drop}{Whether to drop marginalized dimensions. If chunking is
used, this has no effect.}
}
\value{
iterator that returns the values of \code{obj} along with the
index of the object.
}
\description{
Constructs an iterator that returns the elements of an object along with each
element's indices. Enumeration is useful when looping through an
\code{object} and a counter is required.

The \code{i_enumerate} method for arrays allows splitting an
array by arbitrary margins, including by multiple margins. The
\code{index} element returned will be a vector (or if chunking is used, a
matrix) of indices.
}
\details{
This function is intended to follow the convention used in Python's
\code{enumerate} function where the primary difference is that a list is
returned instead of Python's \code{tuple} construct.

Each call to \code{\link[iterators]{nextElem}} returns a list with two
elements:
\describe{
\item{index:}{a counter}
\item{value:}{the current value of \code{object}}
}

\code{i_enum} is an alias to \code{i_enumerate} to save a few keystrokes.

First appeared in package \code{iterators2}.

These are two closely closely related functions:
\code{i_enumerate} accepts an iterable, and will only emit a single
index starting with 1. \code{ienumerate} is a generic with methods for
vectors and arrays, supporting all chunking and recycling
options, and returning multiple indices for arrays.
}
\examples{
set.seed(42)
it <- i_enumerate(rnorm(5))
as.list(it)

# Iterates through the columns of the iris data.frame
it2 <- i_enum(iris)
nextOr(it2, NA)
nextOr(it2, NA)
nextOr(it2, NA)
nextOr(it2, NA)
nextOr(it2, NA)

a <- array(1:27, c(3, 3, 3))
as.list(i_enumerate(a, by=c(1, 2), drop=TRUE))
as.list(i_enumerate(a, by=c(3), drop=FALSE))
as.list(i_enumerate(a, by=c(2, 3), chunkSize=7))
}
\author{
Peter Meilstrup
}
