% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp2var.R
\name{resp2var}
\alias{resp2var}
\title{Two-Way interaction response plot}
\usage{
resp2var(model, variable1 , variable2, modelID = NULL, data = NULL, n = 1000,
         new_data = NULL, extrapolate = FALSE, add_bar = TRUE,
         add_limits = FALSE, color.palette	= NULL, xlab = NULL, ylab = NULL,
         ...)
}
\arguments{
\item{model}{an object of class \code{glm} or \code{enmpa_fitted_models}.}

\item{variable1}{(character) name of the variable to be plotted in x axis.}

\item{variable2}{(character) name of the variable to be plotted in y axis.}

\item{modelID}{(character) name of the ModelID if inputed \code{model} is  in the
\code{enmpa_fitted_models} object.
Default = NULL.}

\item{data}{data.frame or matrix of data to be used in model calibration.
Default = NULL.}

\item{n}{(numeric) an integer guiding the number of breaks. Default = 100}

\item{new_data}{a \code{SpatRaster}, data.frame, or  matrix of variables
representing the range of variable values in an area of interest.
Default = NULL.}

\item{extrapolate}{(logical) whether to allow extrapolation to study the
behavior of the response outside the calibration limits. Ignored if
\code{new_data} is defined. Default = TRUE.}

\item{add_bar}{(logical) whether to add bar legend. Default = TRUE.}

\item{add_limits}{(logical) whether to add calibration limits if
\code{extrapolate = TRUE}. Default = FALSE.}

\item{color.palette}{(function) a color palette function to be used to assign
colors in the plot. Default = function(n) rev(hcl.colors(n, "terrain")).}

\item{xlab}{(character) a label for the x axis. The default, NULL, uses the
name defined in \code{variable1}.}

\item{ylab}{(character) a label for the y axis. The default, NULL, uses the
name defined in \code{variable2}.}

\item{...}{additional arguments passed to
\code{\link[graphics]{image}}.}
}
\value{
A plot with the response interaction of two environmental dimensions for
\code{variable1} and \code{variable2}, and don't return anything.
}
\description{
A view of the species probability into a two-dimensional
environmental space.
}
\details{
The function calculates probabilities by focusing on each combination of the
two supplied environmental variable while keeping all other variables constant
at their mean values.
}
\examples{
# Load a fitted selected model
data(sel_fit, package = "enmpa")

# Two-Way interaction response plot in the calibration limits

resp2var(sel_fit, variable1 = "bio_1", variable2 = "bio_12", xlab = "BIO-1",
ylab = "BIO-12", modelID = "ModelID_7")

# Two-Way interaction response plot allowing extrapolation
resp2var(sel_fit, variable1 = "bio_1", variable2 = "bio_12", xlab = "BIO-1",
ylab = "BIO-12", modelID = "ModelID_7", extrapolate = TRUE)
}
