% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1Dgenerators.R
\name{generate_dist}
\alias{generate_dist}
\title{Generation of GMM data with high precision}
\usage{
generate_dist(X, alpha, mu, sigma, precision)
}
\arguments{
\item{X}{Vector of 1D data.}

\item{alpha}{Vector of alphas (weights) for each distribution.}

\item{mu}{Vector of means for each distribution.}

\item{sigma}{Vector of  sigmas for each distribution.}

\item{precision}{Precision of point linespacing.}
}
\value{
List with following elements:\describe{
   \item{x}{Numeric vector with equaliy spread data of given precison.}
   \item{dist}{Matrix with PDF of each GMM component and cumulative distribution.}
}
}
\description{
Function to generate PDF of GMM distributions and its cumulative results with high lincespacing.
}
\examples{
data <- generate_norm1D(1000, alpha = c(0.2, 0.4, 0.4),
                               mu = c(-15, 0, 15), sigma = c(1, 2, 3))
dist <- generate_dist(data$Dist, alpha = c(0.2, 0.4, 0.4),
                                 mu = c(-15, 0, 15),
                                 sigma = c(1, 2, 3), precision = 1000)

}
\seealso{
\code{\link{runGMM}} and \code{\link{generate_norm1D}}
}
