% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_iter_2D.R
\name{EM_iter_2D}
\alias{EM_iter_2D}
\title{Expectation-maximization algorithm for 2D data}
\usage{
EM_iter_2D(X, Y, init, opts = NULL)
}
\arguments{
\item{X}{Matrix of 2D data to decompose by GMM.}

\item{Y}{Vector of counts, with the same length as "X".
Applies only to binned data (Y = NULL, by default).}

\item{init}{Vector of initial parameters for Gaussian components.}

\item{opts}{Parameters of run stored in \code{\link{GMM_2D_opts}} variable.}
}
\value{
Function returns a \code{list} of GMM parameters for tested number of components: \describe{
 \item{alpha}{Weights (alpha) of each component.}
 \item{center}{Means of decomposition.}
 \item{covar}{Covariances of each component.}
 \item{KS}{Estimated number of components.}
 \item{logL}{Log-likelihood statistic for the estimated number of components.}
 \item{IC}{The value of the selected information criterion which was used to calculate the number of components.}
}
}
\description{
The function performs the EM algorithm to find the local maximum likelihood for the estimated Gaussian mixture parameters.
}
\examples{
\donttest{
data("example2D")
X <- example2D[,1:2]
Y <- matrix(1, 1, nrow(X))

opts <- GMM_2D_opts

# It is necessary to define the initial conditions. Here we use random initialization.
alpha <- matrix(1, 1, opts$KS)/opts$KS
center <- as.matrix(X[sample(nrow(X), opts$KS),])
rownames(center) <- NULL
covar <- replicate(opts$KS, diag(apply(as.matrix(X), 2, sd)/opts$KS), simplify = "array")

init <- list(alpha = alpha,
             center = center,
             covar = covar,
             KS = opts$KS)

gmm <- EM_iter_2D(X, Y, init, opts)
}

}
\seealso{
\code{\link{runGMM2D}}
}
