% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structures.R
\name{job_task}
\alias{job_task}
\title{Job Task}
\usage{
job_task(
  task_key,
  description = NULL,
  depends_on = c(),
  existing_cluster_id = NULL,
  new_cluster = NULL,
  job_cluster_key = NULL,
  task,
  libraries = NULL,
  email_notifications = NULL,
  timeout_seconds = NULL,
  max_retries = 0,
  min_retry_interval_millis = 0,
  retry_on_timeout = FALSE,
  run_if = c("ALL_SUCCESS", "ALL_DONE", "NONE_FAILED", "AT_LEAST_ONE_SUCCESS",
    "ALL_FAILED", "AT_LEAST_ONE_FAILED")
)
}
\arguments{
\item{task_key}{A unique name for the task. This field is used to refer to
this task from other tasks. This field is required and must be unique within
its parent job. On \code{\link[=db_jobs_update]{db_jobs_update()}} or \code{\link[=db_jobs_reset]{db_jobs_reset()}}, this field is
used to reference the tasks to be updated or reset. The maximum length is
100 characters.}

\item{description}{An optional description for this task. The maximum length
is 4096 bytes.}

\item{depends_on}{Vector of \code{task_key}'s specifying the dependency graph of
the task. All \code{task_key}'s specified in this field must complete successfully
before executing this task. This field is required when a job consists of
more than one task.}

\item{existing_cluster_id}{ID of an existing cluster that is used for all
runs of this task.}

\item{new_cluster}{Instance of \code{\link[=new_cluster]{new_cluster()}}.}

\item{job_cluster_key}{Task is executed reusing the cluster specified in
\code{\link[=db_jobs_create]{db_jobs_create()}} with \code{job_clusters} parameter.}

\item{task}{One of \code{\link[=notebook_task]{notebook_task()}}, \code{\link[=spark_jar_task]{spark_jar_task()}},
\code{\link[=spark_python_task]{spark_python_task()}}, \code{\link[=spark_submit_task]{spark_submit_task()}}, \code{\link[=pipeline_task]{pipeline_task()}},
\code{\link[=python_wheel_task]{python_wheel_task()}}.}

\item{libraries}{Instance of \code{\link[=libraries]{libraries()}}.}

\item{email_notifications}{Instance of \link{email_notifications}.}

\item{timeout_seconds}{An optional timeout applied to each run of this job
task. The default behavior is to have no timeout.}

\item{max_retries}{An optional maximum number of times to retry an
unsuccessful run. A run is considered to be unsuccessful if it completes with
the \code{FAILED} \code{result_state} or \code{INTERNAL_ERROR} \code{life_cycle_state.} The value
-1 means to retry indefinitely and the value 0 means to never retry. The
default behavior is to never retry.}

\item{min_retry_interval_millis}{Optional minimal interval in milliseconds
between the start of the failed run and the subsequent retry run. The default
behavior is that unsuccessful runs are immediately retried.}

\item{retry_on_timeout}{Optional policy to specify whether to retry a task
when it times out. The default behavior is to not retry on timeout.}

\item{run_if}{The condition determining whether the task is run once its
dependencies have been completed.}
}
\description{
Job Task
}
