% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bid_anticipate.R
\name{bid_anticipate}
\alias{bid_anticipate}
\title{Document User Behavior Anticipation Stage in BID Framework}
\usage{
bid_anticipate(
  previous_stage,
  bias_mitigations = NULL,
  include_accessibility = TRUE,
  quiet = NULL,
  ...
)
}
\arguments{
\item{previous_stage}{A tibble or list output from an earlier BID stage
function.}

\item{bias_mitigations}{A named list of bias mitigation strategies. If NULL,
the function will suggest bias mitigations based on information from
previous stages.}

\item{include_accessibility}{Logical indicating whether to include
accessibility mitigations. Default is TRUE.}

\item{quiet}{Logical indicating whether to suppress informational messages.
If NULL, uses getOption("bidux.quiet", FALSE).}

\item{...}{Additional parameters. If 'interaction_principles' is provided,
it will be ignored with a warning.}
}
\value{
A tibble containing the documented information for the "Anticipate"
stage.
}
\description{
This function documents the anticipated user behavior by listing bias
mitigation strategies related to anchoring, framing, confirmation bias, etc.
It also supports adding interaction hints and visual feedback elements.
}
\examples{
interpret_stage <- bid_interpret(
  central_question = "How can we improve selection efficiency?",
  data_story = list(
    hook = "Too many options",
    context = "Excessive choices",
    tension = "User frustration",
    resolution = "Simplify menu"
  )
)

notice_stage <- bid_notice(
  previous_stage = interpret_stage,
  problem = "Issue with dropdown menus",
  evidence = "User testing indicated delays"
)

structure_info <- bid_structure(previous_stage = notice_stage)

# Let the function suggest bias mitigations based on previous stages
bid_anticipate(previous_stage = structure_info)

# with accessibility included (default) and custom bias mitigations
anticipate_result <- bid_anticipate(
  previous_stage = structure_info,
  bias_mitigations = list(
    anchoring = "Use context-aware references",
    framing = "Toggle between positive and negative framing"
  ),
  include_accessibility = TRUE
)

summary(anticipate_result)

}
