% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_get_data.R
\name{sc_get_nlcd}
\alias{sc_get_nlcd}
\alias{sc_nlcd}
\title{Get NLCD Data}
\usage{
sc_get_nlcd(
  year = "2019",
  comid = NULL,
  aoi = NULL,
  showAreaSqKm = NULL,
  showPctFull = NULL,
  state = NULL,
  county = NULL,
  region = NULL,
  conus = NULL,
  countOnly = NULL
)

sc_nlcd(
  year = "2019",
  comid = NULL,
  aoi = NULL,
  showAreaSqKm = NULL,
  showPctFull = NULL,
  state = NULL,
  county = NULL,
  region = NULL,
  conus = NULL,
  countOnly = NULL
)
}
\arguments{
\item{year}{Years(s) of NLCD metrics to query.
Only valid NLCD years are accepted (i.e. 2001, 2004, 2006, 2008,
2011, 2013, 2016, 2019)
Syntax: year=<year1>,<year2>}

\item{comid}{Return metric information for specific COMIDs
Syntax: comid=<comid1>,<comid2>}

\item{aoi}{Specify the area of interest described by a metric. By default, all available areas of interest
for a given metric are returned.
Syntax: areaOfInterest=<value1>,<value2>
Values: catchment|watershed|riparian_catchment|riparian_watershed|other}

\item{showAreaSqKm}{Return the area in square kilometers of a given area of interest.
The default value is false.
Values: true|false}

\item{showPctFull}{Return the pctfull for each dataset. The default value is false.
Values: true|false}

\item{state}{Return metric information for COMIDs within a specific state. Use a state's abbreviation to
query for a given state.
Syntax: state=<state1>,<state2>}

\item{county}{Return metric information for COMIDs within a specific county.
Users must use the FIPS code, not county name, as a way to disambiguate counties.
Syntax: county=<county1>,<county1>}

\item{region}{Return metric information for COMIDs within a specified hydroregion.
Syntax: region=<regionid1>,<regionid2>}

\item{conus}{Return all COMIDs in the conterminous United States.
The default value is false.
Values: true|false}

\item{countOnly}{Return a CSV containing only the row count (ROWCOUNT) and the column
count (COLUMNCOUNT) that the server expects to return in a request. The default value is false.
Values: true|false}
}
\value{
A tibble of desired StreamCat metrics
}
\description{
`r lifecycle::badge("deprecated")`
`sc_nlcd()` was renamed to `sc_get_nlcd()` to create a more consistent API.
Function to retrieve all NLCD metrics for a given year using the StreamCat API.
}
\examples{
\dontrun{

df <- sc_nlcd(year='2001', aoi='cat',comid='179') # Will show a deprecation warning

df <- sc_get_nlcd(year='2001', aoi='cat',comid='179,1337,1337420')

df <- sc_get_nlcd(year='2001', aoi='ws', region='Region01')

df <- sc_get_nlcd(year='2001', aoi='ws', region='Region01',
countOnly=TRUE)

df <- sc_nlcd(year='2001', aoi='ws', region='Region01',
showAreaSqKm=FALSE, showPctFull=TRUE)

df <- sc_get_nlcd(year='2001, 2006', aoi='cat,ws',
comid='179,1337,1337420')
}
}
\author{
Marc Weber
}
\keyword{internal}
