% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvivalWrappers.R
\name{SurvivalBART}
\alias{SurvivalBART}
\title{SurvivalBART}
\usage{
SurvivalBART(
  time,
  status,
  X_train,
  X_test = NULL,
  timescale = "time",
  number_of_trees = 200,
  k = 2,
  N_post = 1000,
  N_burn = 1000,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{time}{Outcome vector of right-censored (non-negative) survival times.}

\item{status}{Event indicator (1 = event, 0 = censored).}

\item{X_train}{Design matrix for training data.}

\item{X_test}{Optional test matrix. If NULL, predictions are computed at
the column means of \code{X_train}.}

\item{timescale}{Either \code{"time"} (log-transform internally) or
\code{"log"} (already log-transformed).}

\item{number_of_trees}{Number of trees in the ensemble. Default is 200.}

\item{k}{Scaling constant used to calibrate the prior variance of the
step heights.}

\item{N_post}{Number of posterior samples to store.}

\item{N_burn}{Number of burn-in iterations.}

\item{verbose}{Logical; print sampling progress.}

\item{...}{Additional arguments passed to \code{\link{ShrinkageTrees}}
to override default hyperparameters.}
}
\description{
Fits an Accelerated Failure Time (AFT) model using the classical
Bayesian Additive Regression Trees (BART) prior:
\eqn{\log(Y) = f(x) + \varepsilon}.
}
\details{
This function provides a survival-specific interface for classical BART
under an AFT formulation for right-censored outcomes.

Structural regularisation is induced through the standard Gaussian
leaf prior and tree depth prior of Chipman, George & McCulloch (2010).

Users requiring alternative shrinkage priors (e.g., Horseshoe or
Dirichlet splitting priors) should use \code{\link{ShrinkageTrees}}
directly.
}
\references{
Chipman, H. A., George, E. I., & McCulloch, R. E. (2010).
Bayesian Additive Regression Trees.
Annals of Applied Statistics.
}
