% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterplot.R
\name{scatterplot}
\alias{scatterplot}
\title{Scatterplot with optional horizontal threshold lines}
\usage{
scatterplot(
  data,
  x = c("station_name", "sample_date"),
  parameter = NULL,
  hline = NULL,
  hline_group_col = NULL,
  hline_value_col = NULL,
  hline_style = list(linetype = "dashed", size = 0.8),
  max_hlines = 5,
  interactive = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{data}{A data.frame or tibble containing at least the following columns:
\code{"station_name"}, \code{"sample_date"}, \code{"value"}, \code{"parameter"}, \code{"unit"}.}

\item{x}{Character. The column to use for the x-axis. Either \code{"station_name"} or \code{"sample_date"}.}

\item{parameter}{Optional character. If provided, only data for this parameter will be plotted.
If \code{NULL}, the function will plot the first parameter found in the dataset.}

\item{hline}{Numeric or data.frame. Horizontal line(s) to add. If numeric, a single line
is drawn at that y-value. If a data.frame, must contain \code{hline_group_col} and \code{hline_value_col} columns.}

\item{hline_group_col}{Character. Column used for grouping when \code{hline} is a data.frame and/or for coloring points (optional).}

\item{hline_value_col}{Character. Column in \code{hline} used for the y-values of horizontal lines.}

\item{hline_style}{List. Appearance settings for horizontal lines. Should contain \code{linetype} and \code{size}.}

\item{max_hlines}{Integer. Maximum number of horizontal line groups to display per parameter when \code{hline} is a data.frame.}

\item{interactive}{Logical. If TRUE, returns an interactive \code{plotly} plot; if FALSE, returns a static \code{ggplot2} plot.}

\item{verbose}{Logical. If TRUE, messages will be displayed during execution. Defaults to TRUE.}
}
\value{
A \code{ggplot} object (if \code{interactive = FALSE}) or a \code{plotly} object (if \code{interactive = TRUE}).
}
\description{
This function creates a scatterplot from a data frame, optionally coloring points
by a grouping column and adding horizontal threshold lines. Supports both static
\code{ggplot2} plots and interactive \code{plotly} plots with a linear/log toggle.
}
\details{
\itemize{
\item If \code{hline} is numeric, a single horizontal line is drawn across the plot.
\item If \code{hline} is a data.frame, only the first \code{max_hlines} groups (sorted alphabetically) are displayed.
\item Points can be colored by \code{hline_group_col} if provided.
\item Interactive plots include buttons to switch between linear and log y-axis scales.
}
}
\examples{
\dontrun{
scatterplot(
  data = my_data,
  x = "station_name",
  parameter = "Chlorophyll-a",
  hline = c(10, 20)
)

scatterplot(
  data = my_data,
  x = "sample_date",
  parameter = "Bacterial abundance",
  hline = thresholds_df,
  hline_group_col = "location_sea_basin",
  hline_value_col = "P99"
)
}

}
\seealso{
\code{\link{load_shark4r_stats}} for loading threshold or summary statistics that
can be used to define horizontal lines in the plot.
}
