% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nua_api_functions.R
\name{get_nua_media_links}
\alias{get_nua_media_links}
\title{Retrieve and extract media URLs from Nordic Microalgae}
\usage{
get_nua_media_links(unparsed = FALSE)
}
\arguments{
\item{unparsed}{Logical. If \code{TRUE}, complete API response is returned as an unparsed list. Default is \code{FALSE}.}
}
\value{
When unparsed = \code{FALSE}: a \code{tibble} with the following columns:
\itemize{
\item \code{slug}: The slug of the related taxon.
\item \code{l_url}: The URL for the "large" rendition.
\item \code{o_url}: The URL for the "original" rendition.
\item \code{s_url}: The URL for the "small" rendition.
\item \code{m_url}: The URL for the "medium" rendition.
}
}
\description{
This function retrieves media information from the Nordic Microalgae API and extracts slugs
and URLs for different renditions (large, original, small, medium) for each media item.
}
\examples{
\donttest{
# Retrieve media information
media_info <- get_nua_media_links(unparsed = FALSE)

# Preview the extracted data
head(media_info)
}
}
\seealso{
\url{https://nordicmicroalgae.org/} for Nordic Microalgae website.

\url{https://nordicmicroalgae.org/api/} for Nordic Microalgae API documentation.
}
