% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{mtbf}
\alias{mtbf}
\title{Mean Time Between Failures (MTBF) for repairable items.}
\usage{
mtbf(failures, totalTime)
}
\arguments{
\item{failures}{Numeric scalar or numeric vector of failure counts (non-negative).}

\item{totalTime}{Numeric scalar or numeric vector of total operating times.}
}
\value{
Numeric scalar: MTBF. If number of failures is zero, returns Inf (with a warning).
}
\description{
MTBF = total operating time / number of failures. The MTBF is the expected time
between consecutive failures. It is commonly used for repairable items. The
behavior is the same as mttf here; keep separate name for semantic clarity.
}
\examples{
mtbf(5, 1000)
mtbf(c(2,3), c(500,500))
}
