% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dMOEW.R
\name{dMOEW}
\alias{dMOEW}
\alias{pMOEW}
\alias{qMOEW}
\alias{rMOEW}
\alias{hMOEW}
\title{The Marshall-Olkin Extended Weibull distribution}
\usage{
dMOEW(x, mu, sigma, nu, log = FALSE)

pMOEW(q, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

qMOEW(p, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

rMOEW(n, mu, sigma, nu)

hMOEW(x, mu, sigma, nu)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{nu}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dMOEW} gives the density, \code{pMOEW} gives the distribution 
function, \code{qMOEW} gives the quantile function, \code{rMOEW}
generates random deviates and \code{hMOEW} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the Marshall-Olkin Extended Weibull distribution
with parameters \code{mu}, \code{sigma} and \code{nu}.
}
\details{
The Marshall-Olkin Extended Weibull distribution \code{mu}, 
\code{sigma} and \code{nu} has density given by

\eqn{f(x) = \frac{\mu \sigma \nu (\nu x)^{\sigma - 1} exp\{{-(\nu x )^{\sigma}}\}}{\{1-(1-\mu) exp\{{-(\nu x )^{\sigma}}\} \}^{2}},}

for \eqn{x > 0}.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(dMOEW(x, mu=0.5, sigma=0.7, nu=1), from=0.001, to=1,
      col="red", ylab="f(x)", las=1)

## The cumulative distribution and the Reliability function
par(mfrow=c(1, 2))
curve(pMOEW(x, mu=0.5, sigma=0.7, nu=1),
      from=0.0001, to=2, col="red", las=1, ylab="F(x)")
curve(pMOEW(x, mu=0.5, sigma=0.7, nu=1, lower.tail=FALSE),
      from=0.0001, to=2, col="red", las=1, ylab="R(x)")

## The quantile function
p <- seq(from=0, to=0.99999, length.out=100)
plot(x=qMOEW(p, mu=0.5, sigma=0.7, nu=1), y=p, xlab="Quantile",
     las=1, ylab="Probability")
curve(pMOEW(x, mu=0.5, sigma=0.7, nu=1),
      from=0, add=TRUE, col="red")

## The random function
hist(rMOEW(n=100, mu=0.5, sigma=0.7, nu=1), freq=FALSE,
     xlab="x", ylim=c(0, 1), las=1, main="")
curve(dMOEW(x, mu=0.5, sigma=0.7, nu=1),
      from=0.001, to=2, add=TRUE, col="red")

## The Hazard function
curve(hMOEW(x, mu=0.5, sigma=0.7, nu=1), from=0.001, to=3,
      col="red", ylab="Hazard function", las=1)

par(old_par) # restore previous graphical parameters
}
\references{
Almalki, S. J., & Nadarajah, S. (2014). Modifications of the 
Weibull distribution: A review. Reliability Engineering & 
System Safety, 124, 32-55.

Ghitany, M. E., Al-Hussaini, E. K., & Al-Jarallah, R. A. (2005). 
Marshall–Olkin extended Weibull distribution and its application 
to censored data. Journal of Applied Statistics, 32(10), 1025-1034.
}
\seealso{
\link{MOEW}
}
\author{
Amylkar Urrea Montoya, \email{amylkar.urrea@udea.edu.co}
}
