% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dGMW.R
\name{dGMW}
\alias{dGMW}
\alias{pGMW}
\alias{qGMW}
\alias{rGMW}
\alias{hGMW}
\title{The Generalized modified Weibull distribution}
\usage{
dGMW(x, mu, sigma, nu, tau, log = FALSE)

pGMW(q, mu, sigma, nu, tau, lower.tail = TRUE, log.p = FALSE)

qGMW(p, mu, sigma, nu, tau, lower.tail = TRUE, log.p = FALSE)

rGMW(n, mu, sigma, nu, tau)

hGMW(x, mu, sigma, nu, tau, log = FALSE)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{scale parameter.}

\item{sigma}{shape parameter.}

\item{nu}{shape parameter.}

\item{tau}{acceleration parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dGMW} gives the density, \code{pGMW} gives the distribution 
function, \code{qGMW} gives the quantile function, \code{rGMW}
generates random deviates and \code{hGMW} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the generalized 
modified weibull distribution with parameters \code{mu}, 
\code{sigma}, \code{nu} and \code{tau}.
}
\details{
The generalized modified weibull with parameters \code{mu}, 
\code{sigma}, \code{nu} and \code{tau} has density given by

\eqn{f(x)= \mu \sigma x^{\nu - 1}(\nu + \tau x) \exp(\tau x - \mu x^{\nu} e^{\tau x})
[1 - \exp(- \mu x^{\nu} e^{\tau x})]^{\sigma-1},}

for \eqn{x > 0}.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(dGMW(x, mu=2, sigma=0.5, nu=2, tau=1.5), from=0, to=0.8,
      ylim=c(0, 2), col="red", las=1, ylab="f(x)") 
 
## The cumulative distribution and the Reliability function
par(mfrow=c(1, 2))
curve(pGMW(x, mu=2, sigma=0.5, nu=2, tau=1.5),
      from=0, to=1.2, col="red", las=1, ylab="F(x)")
curve(pGMW(x, mu=2, sigma=0.5, nu=2, tau=1.5, lower.tail=FALSE),
      from=0, to=1.2, col="red", las=1, ylab="R(x)")

## The quantile function
p <- seq(from=0, to=0.99999, length.out=100)
plot(x=qGMW(p, mu=2, sigma=0.5, nu=2, tau=1.5), y=p, xlab="Quantile",
    las=1, ylab="Probability")
curve(pGMW(x, mu=2, sigma=0.5, nu=2, tau=1.5), from=0, add=TRUE, col="red")
 
## The random function
hist(rGMW(n=1000, mu=2, sigma=0.5, nu=2,tau=1.5), freq=FALSE,
    xlab="x", main ="", las=1)
curve(dGMW(x, mu=2, sigma=0.5, nu=2, tau=1.5),  from=0, add=TRUE, col="red")
 
## The Hazard function
par(mfrow=c(1,1))
curve(hGMW(x, mu=2, sigma=0.5, nu=2, tau=1.5), from=0, to=1, ylim=c(0, 16),
      col="red", ylab="Hazard function", las=1)

par(old_par) # restore previous graphical parameters
}
\seealso{
\link{GMW}
}
