% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckhts.R
\name{rduckhts_tabix}
\alias{rduckhts_tabix}
\title{Create Tabix-Indexed File Table}
\usage{
rduckhts_tabix(
  con,
  table_name,
  path,
  region = NULL,
  index_path = NULL,
  header = NULL,
  header_names = NULL,
  auto_detect = NULL,
  column_types = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{con}{A DuckDB connection with DuckHTS loaded}

\item{table_name}{Name for the created table}

\item{path}{Path to the tabix-indexed file}

\item{region}{Optional genomic region (e.g., "chr1:1000-2000")}

\item{index_path}{Optional explicit path to index file (.tbi/.csi)}

\item{header}{Logical. If TRUE, use first non-meta line as column names}

\item{header_names}{Character vector to override column names}

\item{auto_detect}{Logical. If TRUE, infer basic numeric column types}

\item{column_types}{Character vector of column types (e.g. "BIGINT", "VARCHAR")}

\item{overwrite}{Logical. If TRUE, overwrites existing table}
}
\value{
Invisible TRUE on success
}
\description{
Creates a DuckDB table from any tabix-indexed file using the DuckHTS extension.
}
