% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sine.expansion.R
\name{sine.expansion}
\alias{sine.expansion}
\title{Sine expansion terms}
\usage{
sine.expansion(x, expansions)
}
\arguments{
\item{x}{A numeric matrix of distances at which to evaluate 
the expansion series. For distance analysis, \code{x} should
be the proportion of the maximum sighting distance
at which a group was sighted, i.e., \eqn{x = d/w}, where \eqn{d}
is sighting distance and \eqn{w} is maximum sighting distance.}

\item{expansions}{A scalar specifying the number of 
expansion terms to compute. Must be one of the 
integers 1, 2, 3, 4, or 5.}
}
\value{
A 3D array of size \code{nrow(x)} X \code{ncol(x)} X \code{expansions}.
  The 'pages' (3rd dimension) of this array are the cosine expansions of 
  \code{x}. i.e., page 1 is the first expansion term of \code{x}, 
  page 2 is the second expansion term of \code{x}, etc.
}
\description{
Computes the sine expansion terms that modify the 
shape of distance likelihood functions.
}
\details{
The sine expansion used here is:
  \itemize{
    \item \bold{First term}: \deqn{h_1(x)=\sin(2\pi x)/2,}{h1(x) = sin(2*Pi*x)/2,}
    \item \bold{Second term}: \deqn{h_2(x)=\sin(3\pi x)/2,}{h2(x) = sin(3*Pi*x)/2,}
    \item \bold{Third term}: \deqn{h_3(x)=\sin(4\pi x)/2,}{h3(x) = sin(4*Pi*x)/2,}
    \item \bold{Fourth term}: \deqn{h_4(x)=\sin(5\pi x)/2,}{h4(x) = sin(5*Pi*x)/2,}
    \item \bold{Fifth term}: \deqn{h_5(x)=\sin(6\pi x)/2,}{h5(x) = sin(6*Pi*x)/2,}
  }
  The maximum number of expansion terms is 5.
  
The sine expansion frequency in Rdistance is pi. Each term is one pi more than 
the previous. The cosine expansion frequency in Rdistance is 2*pi. Consequently, 
the sine and cosine expansions fit different models.
}
\examples{
x <- matrix(seq(0, 1, length = 200), ncol = 1)
sin.expn <- sine.expansion(x, 5)
plot(range(x), range(sin.expn), type="n")
matlines(x, sin.expn[,1,1:5], col=rainbow(5), lty = 1)

}
\seealso{
\code{\link{dfuncEstim}}, 
         \code{\link{cosine.expansion}}
}
