% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESW.r
\name{ESW}
\alias{ESW}
\title{Effective Strip Width (ESW) for line transects}
\usage{
ESW(object, newdata = NULL)
}
\arguments{
\item{object}{An Rdistance model frame or fitted distance function,
normally produced by a call to \code{\link{dfuncEstim}}.}

\item{newdata}{A data frame containing new values for 
covariates at which either
ESW's or EDR's will be computed. If NULL and 
  \code{object} contains covariates, the  
  covariates stored in
  \code{object} are used (like \code{\link{predict.lm}}).
  If not NULL, covariate values in \code{newdata}
  are used. 
  See \bold{Value} section for more information.}
}
\value{
If \code{newdata} is present, the returned value is 
a vector of effective sampling distances associated with 
covariate values in \code{newdata}. Length of return 
in this case is the number of rows in \code{newdata}. 
If \code{newdata} is NULL, the returned value is a vector 
of effective sampling distances associated with covariate 
values in \code{object}. Length of return in this case 
is the number of detected groups.  The returned vector 
has measurement units, i.e., \code{object$outputUnits}.
}
\description{
Returns effective strip width (ESW) for 
  line-transect detection functions. 
  See \code{\link{EDR}} is for point transects.
}
\details{
ESW is area under 
  a scaled distance function between its
  left-truncation limit (\code{obj$w.lo}) and its right-truncation 
  limit (\code{obj$w.hi}). \if{latex}{I.e., 
    \deqn{ESW = \int_{w.lo}^{w.hi} g(x)dx,} 
  where \eqn{g(x)} is the distance
  function scaled so that \eqn{g(x.scl) = g.x.scl}
  and \eqn{w.lo} and \eqn{w.hi} are the lower
  and upper truncation limits.  }
  
  If detection does not decline with distance, 
  the detection function is flat (horizontal), and 
  area under the detection  
  function is  \eqn{g(0)(w.hi - w.lo)}.  
  If, in this case, \eqn{g(0) = 1}, effective sampling distance is 
  the half-width of the surveys, \eqn{(w.hi - w.lo)}
}
\examples{
data(sparrowDfuncObserver)

ESW(sparrowDfuncObserver) # vector length 356 = number of groups
ESW(sparrowDfuncObserver, newdata = data.frame(observer = 
   c("obs2", "obs4"))) # vector length 2

}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{EDR}}, 
\code{\link{effectiveDistance}}
}
