% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fixed_effects_from_average_outcome}
\alias{fixed_effects_from_average_outcome}
\title{Calculate Fixed-Effects Coefficients from Mean Outcomes}
\usage{
fixed_effects_from_average_outcome(formula, outcome, family = "gaussian")
}
\arguments{
\item{formula}{The fixed-effects part of the model formula (e.g., \code{y ~ group * time}).}

\item{outcome}{A data frame containing columns for all predictor variables and
exactly one column for the expected outcome values.}

\item{family}{The model family (\code{"gaussian"}, \code{"binomial"}, \code{"poisson"}).
The outcome values should be means for gaussian, probabilities (0-1) for
binomial, and non-negative rates/counts for poisson.}
}
\value{
A named list of coefficients suitable for the \code{fixed_effects}
argument in \code{power_sim()}.
}
\description{
A user-friendly helper function to translate expected outcomes (e.g., cell
means, probabilities, or rates) into the regression coefficients required
by the simulation. This is often more intuitive than specifying coefficients directly.
}
\examples{
outcome_means <- tidyr::expand_grid(
  group = c("Control", "Treatment"),
  time = c("pre", "post")
)
outcome_means$mean <- c(10, 10, 12, 15) # Specify expected means

fixed_effects_from_average_outcome(
  formula = score ~ group * time,
  outcome = outcome_means
)
}
