% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographicsQuery.R
\name{addAgeQuery}
\alias{addAgeQuery}
\title{Query to add the age of the individuals at a certain date}
\usage{
addAgeQuery(
  x,
  indexDate = "cohort_start_date",
  ageName = "age",
  ageGroup = NULL,
  ageMissingMonth = 1,
  ageMissingDay = 1,
  ageImposeMonth = FALSE,
  ageImposeDay = FALSE,
  ageUnit = "years",
  missingAgeGroupValue = "None"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{indexDate}{Variable in x that contains the date to compute the
demographics characteristics.}

\item{ageName}{Age variable name.}

\item{ageGroup}{if not NULL, a list of ageGroup vectors.}

\item{ageMissingMonth}{Month of the year assigned to individuals with missing
month of birth.}

\item{ageMissingDay}{day of the month assigned to individuals
with missing day of birth.}

\item{ageImposeMonth}{TRUE or FALSE. Whether the month of the date of birth
will be considered as missing for all the individuals.}

\item{ageImposeDay}{TRUE or FALSE. Whether the day of the date of birth
will be considered as missing for all the individuals.}

\item{ageUnit}{Unit for age it can either be 'years', 'months' or 'days'.}

\item{missingAgeGroupValue}{Value to include if missing age.}
}
\value{
tibble with the age column added.
}
\description{
Same as \code{addAge()}, except query is not computed to a table.
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles(source = "duckdb")

cdm$cohort1 |>
  addAgeQuery()

}
}
