test_that("calibrate_temperature finds reasonable T", {
  profiles <- list(
    corn_ctrl   = c(0.80, 0.90, 0.60),
    corn_trt    = c(0.50, 0.40, 0.55),
    barley_ctrl = c(0.35, 0.30, 0.45),
    barley_trt  = c(0.20, 0.15, 0.50)
  )
  cal <- calibrate_temperature(profiles)
  expect_true(cal$optimal_T > 0)
  expect_true(abs(cal$mean_perplexity - 2.0) < 0.15)
  expect_equal(length(cal$profile_perplexities), 4)
})

test_that("calibrate_temperature handles different targets", {
  profiles <- list(a = c(0.8, 0.5, 0.3), b = c(0.6, 0.6, 0.6))
  cal_sharp <- calibrate_temperature(profiles, target_perplexity = 1.5)
  cal_soft  <- calibrate_temperature(profiles, target_perplexity = 2.5)
  expect_true(cal_sharp$optimal_T < cal_soft$optimal_T)
})

test_that("calibrate_temperature validates inputs", {
  expect_error(calibrate_temperature(list()))
  expect_error(calibrate_temperature(list(c(0.5))))  # only 1 element
  expect_error(calibrate_temperature(list(c(0.5, 0.3)), target_perplexity = -1))
})
