% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_all.R
\name{calculate_nue_batch}
\alias{calculate_nue_batch}
\title{Calculate All NUE Indicators (Batch Processing)}
\usage{
calculate_nue_batch(
  data,
  yield_f = "YieldF",
  yield_0 = "Yield0",
  fert_n = "FertN",
  plant_n_f = "PlantNf",
  plant_n_0 = "PlantN0",
  yield_n = "YieldN",
  soil_n = "SoilN",
  plant_bm = "PlantBM",
  plant_15n = "Plant15N",
  fert_15n = "Fert15N",
  gr = "GR",
  n_con = "Ncon",
  n_rec = "Nrec",
  n_loss = "Nloss",
  n_in = "Ni",
  n_out = "No",
  delta_soil_n = "delSoilN",
  mrt = "MRT"
)
}
\arguments{
\item{data}{A dataframe containing experimental data.}

\item{yield_f}{Column name for Fertilized Yield. Default: "YieldF"}

\item{yield_0}{Column name for Control Yield. Default: "Yield0"}

\item{fert_n}{Column name for Fertilizer N input. Default: "FertN"}

\item{plant_n_f}{Column name for Plant N (fertilized). Default: "PlantNf"}

\item{plant_n_0}{Column name for Plant N (control). Default: "PlantN0"}

\item{yield_n}{Column name for N removed as yield. Default: "YieldN"}

\item{soil_n}{Column name for Soil N. Default: "SoilN"}

\item{plant_bm}{Column name for Plant Biomass. Default: "PlantBM"}

\item{plant_15n}{Column name for Plant 15N excess. Default: "Plant15N"}

\item{fert_15n}{Column name for Fertilizer 15N excess. Default: "Fert15N"}

\item{gr}{Column name for Plant Growth Rate. Default: "GR"}

\item{n_con}{Column name for N available for consumption. Default: "Ncon"}

\item{n_rec}{Column name for N recycled. Default: "Nrec"}

\item{n_loss}{Column name for N lost from system. Default: "Nloss"}

\item{n_in}{Column name for Total N Input (System). Default: "Ni"}

\item{n_out}{Column name for Total N Output (System). Default: "No"}

\item{delta_soil_n}{Column name for Change in Soil N. Default: "delSoilN"}

\item{mrt}{Column name for Mean Residency Time. Default: "MRT"}
}
\value{
A dataframe with new columns appended for every calculable metric.
}
\description{
Automatically detects available data columns and calculates all 23 NUE indicators.
}
\examples{
# Create a simple dataset
df <- data.frame(
  YieldF = c(3.5, 4.2, 5.0),
  Yield0 = c(2.0, 2.5, 3.0),
  FertN = c(10, 10, 10)
)

# Run the batch calculator
result <- calculate_nue_batch(df)

# View calculated AE column
print(result$AE)
}
