% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TNdfF.R
\name{TNdfF}
\alias{TNdfF}
\title{Calculate Total N derived from Fertilizer (TNdfF)}
\usage{
TNdfF(NdfF, PlantN = NULL, SoilN = NULL)
}
\arguments{
\item{NdfF}{N derived from Fertilizer expressed as a percentage (0-100).}

\item{PlantN}{Optional numeric vector for plant N content.}

\item{SoilN}{Optional numeric vector for soil N content.}
}
\value{
A numeric vector of TNdfF values.
}
\description{
The total quantity of plant or soil N that is derived from fertilizer.
Formula: TNdfF = (NdfF/100) * (PlantN or SoilN)
}
\examples{
NdfF <- c(15, 20)
PlantN <- c(3.0, 3.5)

# Case 1: Using Plant N
TNdfF(NdfF, PlantN = PlantN)

# Case 2: Using Soil N (must specify SoilN explicitly)
SoilN <- c(100, 120)
TNdfF(NdfF, SoilN = SoilN)
}
