#' Calculate NUE of a System (sNUE)
#' @description
#' The fraction of system N outputs that are captured as N yield.
#' Formula: sNUE = YieldN / (YieldN + Nloss)
#' @param YieldN Observed crop yield N.
#' @param Nloss N lost from the system.
#' @return A numeric vector of sNUE values.
#' @examples
#' YieldN <- c(80, 90, 100)
#' Nloss <- c(20, 25, 20)
#' sNUE(YieldN, Nloss)
#' @export
sNUE <- function(YieldN, Nloss) {
  denom <- YieldN + Nloss
  if (any(denom == 0)) stop("Total N (Yield + Loss) cannot be zero.")
  return(YieldN / denom)
}