#' Calculate Partial Factor Productivity (PFP)
#' @description
#' The expression of yield per unit of fertilizer N applied.
#' Formula: PFP = YieldF / FertN
#' @param YieldF A numeric vector of final yield values.
#' @param FertN A numeric value or vector for fertilizer N input.
#' @return A numeric vector of PFP values.
#' @examples
#' YieldF <- c(10, 12, 15)
#' FertN <- 50
#' PFP(YieldF, FertN)
#' @export
PFP <- function(YieldF, FertN) {
  if (any(FertN == 0)) {
    stop("FertN cannot be zero.")
  }
  return(YieldF / FertN)
}