% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.NNMoMo.R
\name{fit.NNMoMo}
\alias{fit.NNMoMo}
\title{Fit a Neural Network Lee-Carter Model}
\usage{
\method{fit}{NNMoMo}(
  object,
  data,
  ages.fit = NULL,
  years.fit = NULL,
  series = c("both", "female", "male"),
  fitting.epochs = 2000,
  batch.size = 128,
  ...
)
}
\arguments{
\item{object}{An object of class \code{NNMoMo} specifying the model structure
(e.g., embedding dimension, model type, activation function, loss function).
For more information see \code{\link{lcNN}}.}

\item{data}{An object of class \code{NNMoMoData} containing mortality rates,
population size, and relevant demographic features. See
\code{\link{NNMoMoData}} for details.}

\item{ages.fit}{Optional numeric vector specifying which ages to include
in the fitting process. By default, all available ages are used.}

\item{years.fit}{Optional numeric vector specifying which years to include
in the fitting process. By default, all available years are used.}

\item{series}{Indicates whether to fit the model for "female", "male" or
"both". Default and recommended is "both".}

\item{fitting.epochs}{Positive integer specifying the number of training
epochs for the neural network. Values much lower than 2000 are not
recommended.}

\item{batch.size}{Positive integer specifying the batch size when training
the model. A batch size of 128 is recommended as it was found to work the
smoothest.}

\item{...}{Arguments to be passed to or from other methods.}
}
\value{
An object of class \code{fitNNMoMo}, where each element is a
\code{fitStMoMo}-like object containing the estimated parameters \eqn{a_x},
\eqn{b_x}, \eqn{k_t}, the underlying data, and other metadata from the model
fitting. These objects can be further used with functions from the
\pkg{StMoMo} package for analysis, plotting, or extracting fitted mortality
rates and exposures.
}
\description{
Fit a neural network mortality model based on prepared \code{NNMoMo} and
\code{NNMoMoData} objects. The function allows selection of specific ages
and years for fitting, restriction to particular series (female", "male" or
"both"), and control of the training epochs. The model is trained using
\code{torch} and \code{luz} and returns a list of \code{fitStMoMo}-like
objects.
}
\details{
Missing or zero values in the mortality rates are imputed using the average
value at a certain age across all countries for that gender in that year.
Data are processed for each combination of year and sex. Categorical
variables such as country and sex are embedded via embedding layers.
}
\examples{
\donttest{
if (torch::torch_is_installed()) {
  # Example: fitting with random data, do not expect to get
  # any meaningful results.

  # creating example data for fitting:
  demography_obj <- demography::demogdata(
    data = matrix(runif(10*5), nrow = 10),
    pop = matrix(runif(10*5, 1000, 2000), nrow = 10),
    ages = 50:59,
    years = 2000:2004,
    type = "mortality",
    name = "male",
    label = "France"
  )
  nn_data <- NNMoMoData(demography_obj)

  # fitting the data in 10 epochs (in practice, many more epochs are needed):
  fit <- fit(object = lcNN(),
             data = nn_data,
             fitting.epochs = 10)

  plot(fit$France_male)
}
}

}
