% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_functions.R
\name{setup_output_file}
\alias{setup_output_file}
\title{Structure a new HDF5 file}
\usage{
setup_output_file(
  inname,
  outname,
  site,
  analyte,
  attrs = NULL,
  keep_open = FALSE
)
}
\arguments{
\item{inname}{Input file name.}

\item{outname}{Output file name.}

\item{site}{NEON 4-letter site code.}

\item{analyte}{Carbon ('Co2') or water ('H2o') system?}

\item{attrs}{Pre-read attributes list from the input file. If NULL
(default), attributes are read from \code{inname}.}

\item{keep_open}{If TRUE, return the open file handle instead of
closing it. The caller is responsible for closing via \code{h5_close()}.}
}
\value{
If \code{keep_open = TRUE}, returns the open HDF5 file handle.
Otherwise nothing (creates a new data file with basic HDF5
structure consistent with NEON's data files).
}
\description{
Creates a skeleton HDF5 file for the calibrated data,
essentially setting up the HDF5 groups at the /site/dp01/\{data,ucrt,qfqm\}
level.
}
\author{
Rich Fiorella \email{rfiorella@lanl.gov}
}
