% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.r
\name{SampleMomCum}
\alias{SampleMomCum}
\title{Estimation of multivariate T-Moments and T-Cumulants}
\usage{
SampleMomCum(X, r, centering = FALSE, scaling = TRUE)
}
\arguments{
\item{X}{d-vector data}

\item{r}{The highest moment order (r >2)}

\item{centering}{set to T (and scaling = F) if only centering is needed}

\item{scaling}{set to T (and centering=F) if standardization of multivariate data is needed}
}
\value{
\code{estMu.r}: the list of the multivariate moments up to order \code{r}

\code{estCum.r}: the list of the multivariate cumulants up to order \code{r}
}
\description{
Provides estimates of univariate and multivariate moments and cumulants up to order r.
By default data are standardized; using only demeaned or raw data is also possible.
}
\examples{
## generate random data from a 3-variate skew normal distribution
alpha<-c(10,5,0)
omega<-diag(3)
x<-rSkewNorm(50,omega,alpha)
## estimate the first three moments and cumulants from raw (uncentered and unstandardized) data
SampleMomCum(x,3,centering=FALSE,scaling=FALSE)
## estimate the first three moments and cumulants from standardized data
SampleMomCum(x,3,centering=FALSE,scaling=TRUE)

}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.
}
\seealso{
Other Estimation: 
\code{\link{SampleEVSK}()},
\code{\link{SampleKurt}()},
\code{\link{SampleSkew}()},
\code{\link{VarianceKurt}()},
\code{\link{VarianceSkew}()}
}
\concept{Estimation}
