% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalized_pcg_wrappers.R
\name{blasso_pcg_lambda2_va}
\alias{blasso_pcg_lambda2_va}
\title{Bayesian lasso PCG sampler: lambda2 collapsed over local scales}
\usage{
blasso_pcg_lambda2_va(
  vy,
  mX,
  a,
  b,
  u,
  v,
  nsamples,
  lambda_init = 1,
  sigma2_init = 1,
  verbose = max(1L, floor(as.integer(nsamples)/10))
)
}
\arguments{
\item{vy}{Numeric response vector of length n.}

\item{mX}{Numeric design matrix of dimension n x p.}

\item{a, b}{Hyperparameters for the inverse-gamma prior on \eqn{\sigma^2}.}

\item{u, v}{Hyperparameters for the prior on \eqn{\lambda^2}.}

\item{nsamples}{Number of MCMC iterations.}

\item{lambda_init}{Initial value for \eqn{\lambda}.}

\item{sigma2_init}{Initial value for \eqn{\sigma^2}.}

\item{verbose}{Print progress every \code{verbose} iterations (0 = silent).}
}
\value{
A list with components:
\describe{
  \item{mBeta}{Matrix of beta draws (nsamples x p).}
  \item{vsigma2}{Vector of sigma^2 draws (length nsamples).}
  \item{vlambda2}{Vector of lambda^2 draws (length nsamples).}
}
}
\description{
Lasso-specific Partially-collapsed Gibbs (PCG) variant with the local scales (va) collapsed in the
\eqn{\lambda^2} update.
}
\examples{
set.seed(1)
n <- 40; p <- 6
X <- matrix(rnorm(n * p), n, p)
beta <- c(1.2, 2, -1, 0.5, 0.75, 2.5)
y <- X \%*\% beta + rnorm(n)

out <- blasso_pcg_lambda2_va(
  vy = y, mX = X,
  a = 1, b = 1, u = 1, v = 1,
  nsamples = 200,
  lambda_init = 1, sigma2_init = 1,
  verbose = 0
)

summary(out$vlambda2)

}
