% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par_logn_mix_known.r
\name{par_logn_mix_known}
\alias{par_logn_mix_known}
\title{Estimate the parameters of a lognormal-Pareto density, assuming a known threshold}
\usage{
par_logn_mix_known(y, prior1, th, alpha, mu, sigma)
}
\arguments{
\item{y}{non-negative numerical vector: random sample from the mixture.}

\item{prior1}{scalar (0<prior1<1): starting value of the prior probability.}

\item{th}{positive scalar: threshold.}

\item{alpha}{non-negative scalar: starting value of the Pareto shape parameter.}

\item{mu}{scalar: starting value of the lognormal parameter mu.}

\item{sigma}{positive scalar: starting value of the lognormal parameter sigma.}
}
\value{
A list with the following elements:

xmin: estimated threshold.

prior: estimated mixing weight.

post: matrix of posterior probabilities.

alpha: estimated Pareto shape parameter.

mu: estimated expectation of the lognormal distribution on the lognormal scale.

sigma: estimated standard deviation of the lognormal distribution on the lognormal scale.

loglik: maximized log-likelihood.

nit: number of iterations.
}
\description{
This function estimates the parameters of a Pareto and a lognormal density, assuming a known threshold.
}
\examples{
mixFit <- par_logn_mix_known(TN2016, .5, 4700, 3, 7, 1.2)
}
