% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvm.R
\name{tvm}
\alias{tvm}
\title{Time-Varying Mean (TVM)}
\usage{
tvm(data, subject_id, time, response, k = 2, verbose = FALSE)
}
\arguments{
\item{data}{A dataframe containing the longitudinal data.}

\item{subject_id}{A column specifying the column name for subject IDs.}

\item{time}{A column specifying different time points that observations are measured.}

\item{response}{A column specifying the column name for response values.}

\item{k}{A numeric value specifying the number of standard deviations to use as the threshold (default = 2).}

\item{verbose}{Logical; if TRUE, prints informative messages during execution.}
}
\value{
A list containing:
\item{influential_subjects}{A vector of subject IDs identified as influential.}
\item{influential_data}{A data frame containing data for influential subjects.}
\item{influential_time_data}{A data frame containing data for influential subjects with only the influential time points.}
\item{non_influential_data}{A data frame containing data for non-influential subjects.}
\item{mean_response_plot}{A plot visualizing the mean response values across time points.}
\item{longitudinal_plot}{A final plot highlighting influential subjects over time.}
\item{IS_table}{A data frame containing the Influence Score (IS) and the Partial Influence Score (PIS) values for each subject at each time point.}
}
\description{
This function detects influential subjects based on their response values at different time points.
It calculates the mean and standard deviation of responses at each time point and flags subjects whose
response values deviate significantly beyond a threshold. The function also generates plots to visualize
influential observations and their trends over time. It also computes the Influence Score (IS) and Partial
Influence Score (PIS) for each observation.
}
\details{
The function follows these steps:
\itemize{
  \item Computes the mean and standard deviation of response values at each time point.
  \item Calculates Influence Score (IS) and Partial Influence Score (PIS) for each observation.
  \item Identifies subjects whose response values exceed the threshold based on \code{k} standard deviations.
  \item Separates influential and non-influential subjects for further analysis.
  \item Generates visualizations of mean responses and highlights influential subjects in a longitudinal plot.
}

This method is useful for identifying outliers and understanding variability in longitudinal studies.
}
\examples{
data(infsdata)
infsdata <- infsdata[1:5,]
result <- tvm(infsdata, "subject_id", "time", "response", 2)
print(result$influential_subjects)
head(result$influential_data)
head(result$non_influential_data)
head(result$influential_time_data)
head(result$IS_table)
head(result$PIS_table)
result$mean_response_plot
result$longitudinal_plot

}
\seealso{
slm, wlm, sld, rld
}
