% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HaploDip_Neis_H.R
\name{summarize_NeisH}
\alias{summarize_NeisH}
\title{Summarize per-window Nei's H per population}
\usage{
summarize_NeisH(neis_table)
}
\arguments{
\item{neis_table}{A [data.table::data.table] produced by [compute_Hs_W()],
containing at minimum the columns \code{Pop}, \code{N_sites}, and
\code{Neis_H}.}
}
\value{
A [tibble::tibble] with one row per population and the following
  columns:
  \describe{
    \item{Pop}{Population label.}
    \item{wMean.Neis_H}{Weighted mean of Nei's H across all windows.}
    \item{wSD.Neis_H}{Weighted standard deviation of Nei's H across all
      windows.}
  }
}
\description{
Computes the site-count-weighted mean and standard deviation of Nei's H
across all windows for each population, using the per-window table produced
by [compute_Hs_W()]. Weighting by \code{N_sites} ensures that windows with
more called genotypes contribute more to the estimate.
}
\examples{
vcf_path <- system.file("extdata",
                        "example.vcf",
                        package = "HaploDiploidEquilibrium")

result <- vcf2GT(vcf_path)
gt       <- result$gt_matrix
contigs  <- result$contig_vector
pos      <- result$positions

pop.file <- data.frame(ID  = colnames(gt),
                       Pop = c("PopA","PopA","PopB","PopB","PopB"))

hs <- compute_Hs_W(geno.data   = gt,
                   pop.file    = pop.file,
                   contigs     = contigs,
                   positions   = pos,
                   window.size = 10000)
summary <- summarize_NeisH(hs)

}
\seealso{
[compute_Hs_W()] for computing the input per-window table.
}
