% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_eval_functions.R
\name{dm.test.bt.fb}
\alias{dm.test.bt.fb}
\title{Diebold-Mariano Test (Bartlett kernel, fixed-b approximation)}
\usage{
dm.test.bt.fb(d, M = NA, Mopt = NA, cl = 0.05)
}
\arguments{
\item{d}{loss differential}

\item{M}{truncation parameter for the Bartlett kernel (if \code{M = NA}, then \code{Mopt = 1} by default)}

\item{Mopt}{option for automatic bandwidth, 1 if Lazarus et al. (2018, default), 2 if Newey and West (1994), 3 if Andrews textbook NW (\eqn{M=\lceil 0.75T^{1/3}\rceil}), 4 if CI baseline (\eqn{M=\lfloor T^{1/2}\rfloor})}

\item{cl}{confidence level (default = 0.05, i.e., 5\%), Only 0.05 (5\%) or 0.10 (10\%) are allowed.}
}
\value{
This function returns a class with the following elements
\itemize{
\item \code{rej} is a T/F value. TRUE (reject), FALSE (accept)
\item \code{stat} is a test statistic
}
}
\description{
Diebold-Mariano Test (Bartlett kernel, fixed-b approximation). This is a two-sided test.
}
\author{
Minchul Shin
}
