% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Tradeoff.R
\name{Plot_Tradeoff}
\alias{Plot_Tradeoff}
\title{Visualizes the size distortion maximum power loss tradeoff from the Diebold-Mariano test for equal predictive accuracy}
\usage{
Plot_Tradeoff(
  data,
  f1 = NULL,
  f2 = NULL,
  y = NULL,
  loss_function = NULL,
  n_sim = 1000,
  m_set = NULL,
  cl = 0.05,
  verbose = TRUE,
  no_m_label = FALSE,
  na_handling = c("zero", "drop", "error")
)
}
\arguments{
\item{data}{A data frame.}

\item{f1}{Column containing forecaster 1's predictions. Should be a string.}

\item{f2}{Column containing forecaster 2's predictions. Should be a string.}

\item{y}{Column containing the realized value for the outcome variable. Should be a string.}

\item{loss_function}{The transformation applied to the forecast error. Defaults to squared error loss. The user supplied function should take two inputs and a scalar output, loss = loss_function(f, y). For example, quadratic loss function would be defined as \code{loss_function=function(f,y){(f-y)^2}}.}

\item{n_sim}{The number of simulations used to generate the ARIMA model. Defaults to 1,000.}

\item{m_set}{The truncation parameter. If \code{NULL}, the function constructs a default grid centered around the package default bandwidth for \code{dm.test.bt.fb}, \eqn{M_0 = \lceil 1.3\sqrt{T}\rceil} (LLSW), where \eqn{T} is the effective sample size after applying \code{na_handling}. It should be a vector of integers with the values of M you would like to plot.}

\item{cl}{Significance level used in the hypothesis test. Defaults to 0.05. Only 0.05 and 0.10 are currently supported because the fixed-b approximation is implemented for these levels.}

\item{verbose}{TRUE to print out the progress to the console. Defaults to TRUE.}

\item{no_m_label}{TRUE to plot without m labels. Defaults to FALSE.}

\item{na_handling}{How to handle missing/non-finite loss differentials. \code{"zero"} (default) replaces them with 0 (Application 2 convention), \code{"drop"} removes them (Application 1 convention), and \code{"error"} stops if any are present.}
}
\value{
A list of length 2. The first element is a ggplot2 object of the size-power tradeoff. The second element is the underlying data used to construct the plot in element 1.
}
\description{
`Plot_Tradeoff` creates a plot to show sensitivity of statistical significance to the choice of bandwidth and how size distortion and maximum power loss vary.
It is designed for the Diebold-Mariano test for equal predictive accuracy (Diebold and Mariano, 1995).
For a size-power tradeoff plot, see Lazarus, Lewis, Stock, and Watson (2018) and Lazarus, Lewis, and Stock (2021).
}
\examples{
\donttest{
# A typical example
set.seed(1234)
output = Plot_Tradeoff(
  data = TBILL,
  f1   = "SPFfor_Step1",
  f2   = "NCfor_Step1",
  y    = "Realiz1",
  m_set = seq(from = 1, to = 70, by = 10)
)
output[[1]] # The first element is a ggplot2 object of the size-power tradeoff.
output[[2]] # The second element is the underlying data used to construct the plot in element 1.

# An example with a user supplied loss function
# To use the mean absolute error as a loss function rather than a quadratic loss function
set.seed(1234)
output = Plot_Tradeoff(
  data = TBILL,
  f1   = "SPFfor_Step1",
  f2   = "NCfor_Step1",
  y    = "Realiz1",
  loss_function = function(f,y){ abs(f-y) },
  m_set = seq(from = 1, to = 50, by = 10)
)

# An example without (f1, f2, y). The function will take the first three columns and use them
set.seed(1234)
tmpdata = TBILL[, c("SPFfor_Step1", "NCfor_Step1", "Realiz1")] # data with [f1, f2, y]
Plot_Tradeoff(
  data = tmpdata,
  m_set = seq(from = 1, to = 50, by = 10)
)
}

}
\references{
Diebold, F. X. & Mariano, R. S. (1995), Comparing Predictive Accuracy, \emph{Journal of Business & Economic Statistics}, \bold{13}(3), 253-263.

Lazarus, E., Lewis, D. J., Stock, J. H. & Watson, M. W. (2018), HAR Inference: Recommendations for Practice, \emph{Journal of Business & Economic Statistics}, \bold{36}(4), 541-559.

Lazarus, E., Lewis, D. J. & Stock, J. H. (2021), The Size-Power Tradeoff in HAR Inference, \emph{Econometrica}, \bold{89}(5), 2497-2516.
}
\author{
Nathan Schor and Minchul Shin
}
