test_that("special values are counted correctly", {
  x1 <- c(0, 1, 2, 3, NA, 5, 6, NA, 8, -9)
  x2 <- c(0, 0, -1, 1, NA, NA, 7, 8, 0, 0)
  x3 <- x1/x2
  x4 <- c("AA", "BB", "CC", "", "DD", " ", "EE", "  ", "G", "HHH")
  DF <- data.frame(x1 = x1, x2 = x2, x3 = x3, x4 = x4)
  specSum <- TabulateSpecialValues(DF)
  expect_setequal(as.character(specSum$Variable), c("x1", "x2", "x3", "x4"))
  missCount <- c(2, 2, 4, 0)
  expect_equal(specSum$nMiss, missCount)
  expect_equal(specSum$fracMiss, round(missCount/10, digits = 3))
  blankCount <- c(0, 0, 0, 1)
  expect_equal(specSum$nBlank, blankCount)
  expect_equal(specSum$fracBlank, round(blankCount/10, digits = 3))
  spaceCount <- c(0, 0, 0, 2)
  expect_equal(specSum$nSpaces, spaceCount)
  expect_equal(specSum$fracSpaces, round(spaceCount/10, digits = 3))
  zeroCount <- c(1, 4, 0, 0)
  expect_equal(specSum$nZero, zeroCount)
  expect_equal(specSum$fracZero, round(zeroCount/10, digits = 3))
  negCount <- c(1, 1, 2, 0)
  expect_equal(specSum$nNeg, negCount)
  expect_equal(specSum$fracNeg, round(negCount/10, digits = 3))
})
