% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_code_summary.R
\name{create_code_summary}
\alias{create_code_summary}
\title{Create a Summary Table and Plot of Code Frequencies}
\usage{
create_code_summary(
  excerpts,
  table_min_count = 1,
  table_min_prop = NULL,
  plot = FALSE,
  plot_min_count = NULL,
  plot_min_prop = NULL,
  output_type = c("tibble", "kable", "datatable"),
  exclude = NULL,
  plot_metric = c("count", "prop", "both"),
  fill_color = "steelblue",
  use_labels = FALSE,
  codebook = NULL
)
}
\arguments{
\item{excerpts}{A data frame containing at least one logical or 0/1 variable
representing a code, and a column named \code{media_title} that identifies the source
document or excerpt.}

\item{table_min_count}{Minimum number of excerpts required for a code to appear
in the summary table. Default is 1.}

\item{table_min_prop}{Optional proportion threshold (relative to the maximum count)
for including codes in the table. Default is \code{NULL}.}

\item{plot}{Logical; whether to generate a plot visualizing code frequencies.
Default is \code{FALSE}.}

\item{plot_min_count}{Minimum number of excerpts required for a code to appear
in the plot. Defaults to \code{table_min_count}.}

\item{plot_min_prop}{Optional proportion threshold (relative to the maximum count)
for including codes in the plot. Defaults to \code{table_min_prop}.}

\item{output_type}{The format for the output table. One of \code{"tibble"},
\code{"kable"}, or \code{"datatable"}. Default is \code{"tibble"}.}

\item{exclude}{Optional character vector of variable names to exclude from analysis.}

\item{plot_metric}{The metric to visualize. One of \code{"count"}, \code{"prop"}, or \code{"both"}.
Default is \code{"count"}.}

\item{fill_color}{Color for plot bars. Default is \code{"steelblue"}.}

\item{use_labels}{Logical; if \code{TRUE}, uses a supplied \code{codebook} to display
descriptive labels for codes instead of variable names. Default is \code{FALSE}.}

\item{codebook}{Optional data frame with two columns:
\itemize{
\item \code{variable}: the variable names in the dataset
\item \code{label}: the corresponding human-readable label for each code.
Required when \code{use_labels = TRUE}.
}}
}
\value{
If \code{plot = FALSE}, returns a table in the selected \code{output_type} format.
If \code{plot = TRUE}, invisibly returns a list with two elements:
\describe{
\item{table}{A table of summarized code frequencies.}
\item{plot}{A \code{ggplot} object visualizing the results.}
}
}
\description{
Summarizes how often each qualitative code (represented by logical 0/1 variables)
appears across excerpts or media titles. Optionally produces a frequency table
and visualization of code distributions.

This function automatically handles Stata-labelled (\code{haven_labelled}) or numeric 0/1
variables by converting them to logicals. You can also pass in a custom codebook to
apply human-readable code labels.
}
\details{
The function first identifies all logical (or 0/1 numeric) columns in \code{excerpts}
and calculates:
\itemize{
\item \code{count}: total number of excerpts where the code is applied
\item \code{n_media_titles}: number of distinct media titles containing the code
\item \code{prop_media_titles}: proportion of media titles containing the code (relative to max)
}

The table can be output as a tibble, formatted table (\code{knitr::kable}), or
interactive data table (\code{DT::datatable}).

When \code{plot = TRUE}, the function generates a ggplot2 bar chart showing either
code counts, proportions, or both (dual-axis view).
}
\examples{
# Example 1: Basic usage without a codebook
df <- data.frame(
  media_title = c("Doc1", "Doc2", "Doc3", "Doc4"),
  code_a = c(TRUE, FALSE, TRUE, TRUE),
  code_b = c(FALSE, TRUE, TRUE, FALSE)
)

create_code_summary(df, plot = TRUE)

# Example 2: Using a codebook for readable labels
codebook <- data.frame(
  variable = c("code_a", "code_b"),
  label = c("Community Engagement", "Policy Support")
)

create_code_summary(
  df,
  use_labels = TRUE,
  codebook = codebook,
  plot = TRUE,
  plot_metric = "both"
)

# Example 3: Excluding a code and outputting as datatable
create_code_summary(
  df,
  exclude = "code_b",
  output_type = "datatable"
)

}
