% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DGulPC.R
\name{DGulPC}
\alias{DGulPC}
\title{Distributed Gul Principal Component Analysis}
\usage{
DGulPC(data, m, n1, K)
}
\arguments{
\item{data}{A numeric matrix containing the total dataset.}

\item{m}{An integer specifying the number of principal components for the first stage.}

\item{n1}{An integer specifying the length of each data subset.}

\item{K}{An integer specifying the number of nodes.}
}
\value{
A list with the following components:
\describe{
  \item{AU1}{List of estimated first-stage loading matrices for each node.}
  \item{AU2}{List of estimated second-stage loading matrices for each node.}
  \item{DU3}{List of diagonal residual variance matrices for each node.}
  \item{shat}{List of covariance matrices of reconstructed data for each node.}
}
}
\description{
Performs distributed Gul-type principal component analysis
on a numeric dataset split across multiple nodes.
}
\examples{
set.seed(123)
data <- matrix(rnorm(500), nrow = 100, ncol = 5)
DGulPC(data = data, m = 3, n1 = 20, K = 5)

}
