% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_plot.R
\name{multi_plot}
\alias{multi_plot}
\title{multi_plot: Flexible Static or Interactive Plotting of Variables}
\usage{
multi_plot(
  data,
  x = NULL,
  y = NULL,
  plot_type = NULL,
  interactive = FALSE,
  fill_color = "steelblue",
  color = "black",
  bin_width = NULL,
  group = NULL,
  facet = NULL,
  radar = NULL,
  radar_color = "steelblue",
  radar_labels = NULL,
  radar_cex = 1,
  radar_ref_lev = "Yes",
  title = NULL,
  x_lab = NULL,
  y_lab = NULL,
  legend_position = "right",
  axis_text_angle = 0,
  axis_text_size = 12,
  title_size = 14,
  theme_custom = ggplot2::theme_minimal()
)
}
\arguments{
\item{data}{A data frame or tibble containing your data.}

\item{x}{Character; name of the variable for x-axis (required for all plot types except spider).}

\item{y}{Character; name of the variable for y-axis (required for boxplot, violin, scatter, and heatmap).}

\item{plot_type}{Character; one of \code{"histogram"}, \code{"density"}, \code{"boxplot"},
\code{"barplot"}, \code{"violin"}, \code{"scatter"}, \code{"heatmap"}, or \code{"spider"}.}

\item{interactive}{Logical; if \code{TRUE}, returns a Plotly interactive plot
(not available for spider/radar charts). Default: \code{FALSE}.}

\item{fill_color}{Character; fill color for non-grouped geoms (default \code{"steelblue"}).}

\item{color}{Character; outline/line color (default \code{"black"}).}

\item{bin_width}{Numeric; bin width for histograms. If \code{NULL}, computed automatically.}

\item{group}{Character; name of grouping variable (optional).}

\item{facet}{Character; name of variable to facet by (optional).}

\item{radar}{Character vector; names of exactly 5 variables for spider plot (only for \code{"spider"}).}

\item{radar_color}{Character or vector; border/fill color for spider chart (only for \code{"spider"}).}

\item{radar_labels}{Character or vector; names of the variables for spider chart (only for \code{"spider"}).}

\item{radar_cex}{Numeric; font size for variable labels in the spider chart (only for \code{"spider"}).}

\item{radar_ref_lev}{Character; reference level for factors included in the spider chart (only for \code{"spider"}).}

\item{title}{Character; plot title (optional).}

\item{x_lab}{Character; x-axis label (defaults to \code{x}).}

\item{y_lab}{Character; y-axis label (defaults to \code{y} or \code{"Count"}).}

\item{legend_position}{Character; one of \code{"right","left","top","bottom","none"} (default \code{"right"}).}

\item{axis_text_angle}{Numeric; rotation angle (degrees) for x-axis tick labels (default \code{0}).}

\item{axis_text_size}{Numeric; size of axis text in pts (default \code{12}).}

\item{title_size}{Numeric; size of plot title text in pts (default \code{14}).}

\item{theme_custom}{A ggplot2 theme object (default \code{theme_minimal()}).}
}
\value{
A \code{ggplot} object (if \code{interactive = FALSE} or \code{plot_type = "spider"})
or a \code{plotly} object (if \code{interactive = TRUE}).
}
\description{
Generate a variety of plots—histogram, density, boxplot, barplot, violin, scatter,
heatmap, or spider (radar)—either as static ggplot2 objects or interactive Plotly widgets.
}
\details{
\itemize{
\item \strong{Histogram:} requires \code{x}; uses \code{geom_histogram()}. Use for continuous numeric variables only.
\item \strong{Density:} requires \code{x}; uses \code{geom_density()}. It should be numeric.
\item \strong{Boxplot/Violin:} require both \code{x} and \code{y}; automatically groups by \code{x} or by \code{group} if provided, with dynamic dodge width.
\item \strong{Barplot:} requires \code{x}; counts occurrences. Use for categorical variables only.
\item \strong{Scatter:} requires both \code{x} and \code{y}; uses \code{geom_point()}. Both variables must be numeric.
\item \strong{Heatmap:} requires both \code{x} and \code{y}. Both variables must be categorical.
\item \strong{Spider:} requires \code{radar} (vector of variables); uses \code{fmsb::radarchart()}, static only.
}
}
\examples{

multi_plot(icu,
  x = "icu_enter_days",
  y = "vent_mec_start_days",
  plot_type = "scatter",
  color = "darkred",
  title = "ICU exit vs MV days"
)

multi_plot(
  comorbidities,
  radar = c("hypertension", "dyslipidemia", "depression", "mild_kidney_disease", "dm"),
  radar_color = "steelblue",
  radar_ref_lev = "Yes",
  plot_type = "spider"
)

}
