% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inhosp_antivirals.R
\docType{data}
\name{inhosp_antivirals}
\alias{inhosp_antivirals}
\title{DIVINE's table on antivirals received during hospitalization}
\format{
A data frame with 5813 rows and 10 columns
\describe{
\item{record_id:}{Identifier of each record. This information does not match the real data.}
\item{covid_wave:}{A factor with levels \verb{Wave 1}, \verb{Wave 2}, \verb{Wave 3}, and \verb{Wave 5}. COVID-19 wave.}
\item{center:}{A factor with levels \verb{Hospital A}, \verb{Hospital B}, \verb{Hospital C}, \verb{Hospital D}, and \verb{Hospital E}. Center of admission}
\item{any_antiviral:}{A factor with levels \code{No} and \code{Yes}. Did the patient receive treatment with antivirals during hospital admission?}
\item{hydroxychloroquine:}{A factor with levels \code{No} and \code{Yes}. Treatment with hydroxychloroquine}
\item{interferon_b:}{A factor with levels \code{No} and \code{Yes}. Treatment with interferon beta}
\item{kaletra_ritonavir_lopinavir:}{A factor with levels \code{No} and \code{Yes}. Treatment with kaletra/ritonavir-lopinavir}
\item{remdesivir:}{A factor with levels \code{No} and \code{Yes}. Treatment with remdesivir}
\item{tocilizumab:}{A factor with levels \code{No} and \code{Yes}. Treatment with tocilizumab}
\item{other_antiviral:}{A factor with levels \code{No} and \code{Yes}. Treatment with another antiviral}
}
}
\usage{
data(inhosp_antivirals)
}
\description{
Information on antivirals for patients included in the DIVINE cohort. Data was collected during hospitalization.
}
\references{
Pallarès, N., Tebé, C., Abelenda-Alonso, G., Rombauts, A., Oriol, I., Simonetti, A. F., Rodríguez-Molinero, A., Izquierdo, E., Díaz-Brito, V., Molist, G., Gómez Melis, G., Carratalà, J., Videla, S., & MetroSud and Divine study groups (2023). Characteristics and Outcomes by Ceiling of Care of Subjects Hospitalized with COVID-19 During Four Waves of the Pandemic in a Metropolitan Area: A Multicenter Cohort Study. Infectious diseases and therapy, 12(1), 273–289. https://doi.org/10.1007/s40121-022-00705-w
}
\keyword{datasets}
