% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_plan_of_study.R
\name{create_plan_of_study}
\alias{create_plan_of_study}
\title{Create a plan of study igraph object}
\usage{
create_plan_of_study(
  Course,
  Term,
  Prereq,
  Coreq,
  Credits = NULL,
  LostCredits = NULL,
  PassRate = NULL,
  Timing = NULL,
  Institution = NULL
)
}
\arguments{
\item{Course}{atomic vector - strings for each course}

\item{Term}{a numeric atomic vector - the term  each course is offered}

\item{Prereq}{atomic vector - strings of the courses' prereqs, separated by commas}

\item{Coreq}{atomic vector - strings of the courses' coreqs, separated by commas}

\item{Credits}{numeric atomic vector - number of credits each course is worth (optional)}

\item{LostCredits}{numeric atomic vector - (for transfer students) identifies if credit for the course is not applied toward a student's degree, 1. If it is, 0. (optional)}

\item{PassRate}{numeric atomic vector - pass rates by class (optional)}

\item{Timing}{numeric atomic vector - number of times the course is offered in 2 years (optional)}

\item{Institution}{atomic vector - strings of course affiliations (CC or FY)}
}
\value{
An igraph object of the prerequisite structure
}
\description{
This function takes in a set of courses, their terms, prerequisites, and corequisites.
Optional arguments include the number of credits, pass rates, lost credits from transferring,
and the frequency of course offerings. The function creates an igraph structure of edges and nodes with the
given qualities.
}
\details{
It is recommended that the user imports the data from a csv file to
ensure the indices for each atomic vector correspond to the attributes of one course.
}
