% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newpolyplot.R
\name{polyplotnew}
\alias{polyplotnew}
\title{Plot rankings on a permutation polytope of 3 or 4 objects}
\usage{
polyplotnew(X = NULL, L = NULL, Wk = NULL, nobj = 3, engine = "auto")
}
\arguments{
\item{X}{Sample of rankings (matrix). Usually returned by tabulaterows()}

\item{L}{Labels of the objects (character vector)}

\item{Wk}{Frequency weights for each ranking (numeric vector)}

\item{nobj}{Number of objects: 3 or 4 (integer)}

\item{engine}{Rendering engine for 4-object plots: "auto", "rgl", or "plotly" (character)}
}
\value{
For nobj=3: invisible NULL (creates base graphics plot)
        For nobj=4: invisible NULL for rgl, plotly object for plotly engine
}
\description{
Plot rankings on a permutation polytope of 3 or 4 objects
}
\details{
For 3 objects: uses base R graphics (always available)
For 4 objects: 
  - engine="auto": tries rgl first, falls back to plotly if unavailable
  - engine="rgl": requires 'rgl' package (may need XQuartz on macOS)
  - engine="plotly": requires 'plotly' package (works on all platforms)
}
\references{
Thompson, G. L. (1993). Generalized permutation polytopes and exploratory 
graphical methods for ranked data. The Annals of Statistics, 1401-1430.

Heiser, W. J., and D'Ambrosio, A. (2013). Clustering and prediction of 
rankings within a Kemeny distance framework. In Algorithms from and for 
Nature and Life (pp. 19-31). Springer International Publishing.
}
\author{
Antonio D'Ambrosio, Sonia Amodio
}
