% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitComponent.R
\name{fitComponent}
\alias{fitComponent}
\title{fitComponent}
\usage{
fitComponent(
  toFit,
  min_prior = 0.001,
  min_comp = 2,
  max_comp = 10,
  dist = "norm",
  pR = FALSE,
  seed = 77777,
  model_sel = "BIC",
  niter = 10000,
  nrep = 1
)
}
\arguments{
\item{toFit}{Extracted features to fit models to.}

\item{min_prior}{Minimum prior probability of a cluster. Default is 0.001.}

\item{min_comp}{Minimum number of models to fit. Default is 2.}

\item{max_comp}{Maximum number of models to fit. Default is 10.}

\item{dist}{Type of distribution to fit. Either "norm" or "pois". Default "norm"}

\item{pR}{Peak Reduction reduces peaks in modeling to make modeling easier. Default is FALSE.}

\item{seed}{Seed to be used for modeling. Default is 77777}

\item{model_sel}{Type of model_selection method to be used. Default "BIC". See flexmix package for more options.}

\item{niter}{Max number of iterations for modeling. Default is 1000.}

\item{nrep}{Number of repetitions for modeling attempts. Default is 1.}
}
\value{
Returns the flexmix object for the fit model.
}
\description{
This function is used to fit a mixture model of either normal or poisson
distributions to the inpput data. This function is mainly used by the
fitModels function to create the components from the extracted features.
}
\examples{
fitComponent(featsExp$bp10MB[,2]) #Fits 2-10 normal distributions

#Tries to fit exactly 4 poisson distributions
fitComponent(featsExp$osCN[,2],dist="pois",min_comp = 4, max_comp = 4)
}
