#' addPloidyData
#'
#' This function is used to append your ploidy data onto the sample component
#' matrix. The function is called in runPipeline if you specify ploidy as a 
#' desired feature and give a vector of ploidy values.  
#'
#' @param scm The scm to append the ploidy to
#' @param ploidyData Vector of ploidy date to append to segs
#' @export
#' @return Returns scm including the ploidy data
addPloidyData = function(scm, ploidyData){

  #Checks if there are enough ploidy data values
  if (length(ploidyData) != nrow(scm)) {
    stop(paste("Not enough ploidy values given. Received:",length(ploidyData),
               "Expected:",nrow(scm)))
  }

  if (is.null(names(ploidyData))){
    warning("ploidyData not labelled. Assuming the order is the same as scm.")
    names(ploidyData) = row.names(scm) #Labels ploidyData for later use.
  }
  if (sum(names(ploidyData) %in% row.names(scm)) != nrow(scm)){
    stop(paste("Samples names for ploidyData does not match the",
               "sample names in the scm. Double check",
               "the names of the ploidyData and consider setting",
               "them using the r function names."))
  }
  
  #Makes sure data is in correct order
  ploidyData = ploidyData[row.names(scm)]
  
  scm = cbind(scm,"log2Ploidy" = log2(ploidyData))
  
  return(scm)
}