% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blend.R
\name{Blend}
\alias{Blend}
\title{fit a robust Bayesian longitudinal regularized semi-parametric mixed model}
\usage{
Blend(
  y,
  x,
  t,
  J,
  kn,
  degree,
  iterations = 10000,
  burn.in = NULL,
  robust = TRUE,
  sparse = "TRUE",
  structural = TRUE
)
}
\arguments{
\item{y}{the vector of repeated - measured response variable. The current version of mixed only supports continuous response.}

\item{x}{the matrix of repeated - measured predictors (genetic factors) with intercept. Each row should be an observation vector for each measurement.}

\item{t}{the vector of scheduled time points.}

\item{J}{the vector of number of repeated measurement for each subject.}

\item{kn}{the number of interior knots for B-spline.}

\item{degree}{the degree of B spline basis.}

\item{iterations}{the number of MCMC iterations.}

\item{burn.in}{the number of iterations for burn-in.}

\item{robust}{logical flag. If TRUE, robust methods will be used.}

\item{sparse}{logical flag. If TRUE, spike-and-slab priors will be used to shrink coefficients of irrelevant covariates to zero exactly.}

\item{structural}{logical flag. If TRUE, the coefficient functions with varying effects and constant effects will be penalized separately.}
}
\value{
an object of class `Blend' is returned, which is a list with component:
\item{posterior}{the posteriors of coefficients.}
\item{coefficient}{the estimated coefficients.}
\item{burn.in}{the total number of burn-ins.}
\item{iterations}{the total number of iterations.}
}
\description{
fit a robust Bayesian longitudinal regularized semi-parametric mixed model
}
\details{
Consider the data model described in "\code{\link{data}}":
\deqn{Y_{ij} = \alpha_0(t_{ij})+\sum_{k=1}^{m}\beta_{k}(t_{ij})X_{ijk}+\boldsymbol{Z^\top_{ij}}\boldsymbol{\zeta_{i}}+\epsilon_{ij}.}
The basis expansion and changing of basis with B splines will be done automatically:
\deqn{\beta_{k}(\cdot)\approx \gamma_{k1} + \sum_{u=2}^{q}{B}_{ku}(\cdot)\gamma_{ku}}
where \eqn{B_{ku}(\cdot)} represents B spline basis. \eqn{\gamma_{k1}} and \eqn{(\gamma_{k2}, \ldots, \gamma_{kq})^\top} correspond to the constant and varying parts of the coefficient functional, respectively.
q=kn+degree+1 is the number of basis functions. By default, kn=degree=2. User can change the values of kn and degree to any other positive integers.
When `structural=TRUE`(default), the coefficient functions with varying effects and constant effects will be penalized separately. Otherwise, the coefficient functions with varying effects and constant effects will be penalized together.

When `sparse="TRUE"` (default), spike-and-slab priors are imposed on individual and/or group levels to identify important constant and varying effects. Otherwise, Laplacian shrinkage will be used.

When `robust=TRUE` (default), the distribution of \eqn{\epsilon_{ij}} is defined as a Laplace distribution with density.

\eqn{
f(\epsilon_{ij}|\theta,\tau) = \theta(1-\theta)\exp\left\{-\tau\rho_{\theta}(\epsilon_{ij})\right\}
}, (\eqn{i=1,\dots,n,j=1,\dots,J_{i} }), where \eqn{\theta = 0.5}. If `robust=FALSE`, \eqn{\epsilon_{ij}} follows a normal distribution.
\cr

Please check the references for more details about the prior distributions.
}
\examples{
data(dat)

## default method
fit = Blend(y,x,t,J,kn,degree)
fit$coefficient

\donttest{
## alternative: robust non-structural
fit = Blend(y,x,t,J,kn,degree, structural=FALSE)
fit$coefficient

## alternative: non-robust structural
fit = Blend(y,x,t,J,kn,degree, robust=FALSE)
fit$coefficient

## alternative: non-robust non-structural
fit = Blend(y,x,t,J,kn,degree, robust=FALSE, structural=FALSE)
fit$coefficient

}

}
\seealso{
\code{\link{data}}
}
\keyword{models}
