% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsBioTIME.R
\name{getAlphaMetrics}
\alias{getAlphaMetrics}
\title{Alpha diversity metrics}
\usage{
getAlphaMetrics(x, measure)
}
\arguments{
\item{x}{(\code{data.frame}) BioTIME data in the format of the output of the
\code{\link{resampling}} function. The \code{resamp} column is optional.}

\item{measure}{(\code{character}) chosen currency defined by a single column
name.}
}
\value{
Returns a \code{data.frame} with results for species richness
 (\code{S}), numerical abundance (\code{N}), maximum numerical abundance
 (\code{maxN}), Shannon Index (\code{Shannon}), Exponential Shannon
 (\code{expShannon}), Simpson's Index (Simpson), Inverse Simpson
 (\code{InvSimpson}), Probability of intraspecific encounter (\code{PIE}) and
 McNaughton's Dominance (\code{DomMc}) for each year and \code{assemblageID}.
}
\description{
Calculates a set of standard alpha diversity metrics
}
\details{
The function \code{getAlphaMetrics} computes nine alpha diversity
metrics for a given community data frame, where \code{measure} is a character
input specifying the abundance or biomass field used for the calculations.
For each row of the data frame with data, \code{getAlphaMetrics} calculates
the following metrics:

- Species richness (\code{S}) as the total number of species in each year
with currency > 0.

- Numerical abundance (\code{N}) as the total currency (sum) in each year
(either total abundance or total biomass).

- Maximum Numerical abundance (maxN) as the highest currency value reported
in each year.

- Shannon or Shannon–Weaver index is calculated as
\eqn{\sum_{i}p_{i}log_{b}p_{i}}, where \eqn{p_{i}} is the proportional
abundance of species i and b is the base of the logarithm (natural
logarithms), while exponential Shannon is given by \code{exp(Shannon)}.

- Simpson's index is calculated as \eqn{1-sum(p_{i}^{2})}, while Inverse
Simpson as \eqn{1/sum(p_{i}^{2})}.

- McNaughton's Dominance is calculated as the sum of the pi of the two most
abundant species.

- Probability of intraspecific encounter or PIE is calculated as
\eqn{\left(\frac{N}{N-1}\right)\left(1-\sum_{i=1}^{S}\pi_{i}^{2}\right)}.

 Note that the input data frame needs to be in the format of the output of
 the \code{\link{gridding}} function and/or \code{\link{resampling}}
 functions, which includes keeping the default BioTIME data column names. If
 such columns are not found an error is issued and the computations are
 halted. There is an exception for the \code{resamp} column: the function
 runs even without it.
}
\examples{
  # Mean and sd values of the metrics for several resamplings
  gridding(BTsubset_meta, BTsubset_data) |>
    resampling(measure = "BIOMASS", resamps = 2) |>
    getAlphaMetrics(measure = "BIOMASS") |>
    dplyr::summarise(
       dplyr::across(
          .cols = !resamp, # FIXME
          .fns = c(mean = mean, sd = sd)),
       .by = c(assemblageID, YEAR)) |>
    tidyr::pivot_longer(
       col = dplyr::contains("_"),
       names_to = c("metric", "stat"),
       names_sep = "_",
       names_transform = as.factor) |>
    tidyr::pivot_wider(names_from = stat) |>
    head(10)

}
