% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae.R
\name{aeMoment}
\alias{aeMoment}
\title{Asymptotic Expansion - Moments}
\usage{
aeMoment(ae, m = 1, eps = 1, order = NULL)
}
\arguments{
\item{ae}{an object of class \code{\link{yuima.ae-class}}.}

\item{m}{integer. The moment order. In case of multidimensional processes, it is possible to compute cross-moments by providing a vector of the same length as the state variables.}

\item{eps}{numeric. The intensity of the perturbation.}

\item{order}{integer. The expansion order. If \code{NULL} (default), it uses the maximum order used in \code{ae}.}
}
\value{
numeric.
}
\description{
Asymptotic Expansion - Moments
}
\examples{
\dontrun{
# model
gbm <- setModel(drift = 'mu*x', diffusion = 'sigma*x', solve.variable = 'x')

# settings
xinit <- 100
par <- list(mu = 0.01, sigma = 0.2)
sampling <- setSampling(Initial = 0, Terminal = 1, n = 1000)

# asymptotic expansion
approx <- ae(model = gbm, sampling = sampling, order = 4, true.parameter = par, xinit = xinit)

# second moment, expansion order max
aeMoment(ae = approx, m = 2)

# second moment, expansion order 3
aeMoment(ae = approx, m = 2, order = 3)

# second moment, expansion order 2
aeMoment(ae = approx, m = 2, order = 2)

# second moment, expansion order 1
aeMoment(ae = approx, m = 2, order = 1)
}
}
