% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtra_pars.R
\name{add_prm_association}
\alias{add_prm_association}
\alias{drop_prm_association}
\title{Describe parameter associations}
\usage{
add_prm_association(xpdb, ..., .problem, .subprob, .method, quiet)

drop_prm_association(xpdb, ..., .problem, .subprob, .method, quiet)
}
\arguments{
\item{xpdb}{<\code{xp_xtras}> object}

\item{...}{... <\code{\link[rlang:dyn-dots]{dynamic-dots}}> One or more formulas that
define associations between parameters. One list of formulas can also be used,
but a warning is generated.

For \code{drop_prm_association}, these dots should be selectors for which associations
will be dropped (\verb{the2, the3,...}). Fixed effect selectors only will work.}

\item{.problem}{<\code{numeric}> Problem number to apply this relationship.}

\item{.subprob}{<\code{numeric}> Problem number to apply this relationship.}

\item{.method}{<\code{numeric}> Problem number to apply this relationship.}

\item{quiet}{Silence extra output.}
}
\value{
An updated \code{xp_xtras} object
}
\description{
The relationship between structural parameters and
omega parameters can be described. This is useful if
it deviates from the typical log-normal.

Default transformations are those that are built into
\code{pmxcv}, but see examples for how associations can be
described for other relationships.
}
\details{
At time of writing, the built-in distributions for \code{pmxcv} are below.
Those marked with an asterisk require a fixed effect parameter to calculate CV.
\itemize{
\item \code{log} typical log-normal. Optional \code{exact} parameter (if \code{TRUE}, default, will not
calculate with integration); this is unrelated to the \code{cvtype} option. \strong{Note},
if \code{cvtype} is set to \code{"sqrt"}, log-normal \code{gte_prm} CVs will use the square root, not any integration
or analytical estimate, regardless of how this association is specified..
\item \code{logexp}* modified log-normal \code{log(1+X)}
\item \code{logit}* logit-normal
\item \code{arcsin}* arcsine-transform
\item \code{nmboxcox}* Box-Cox transform as typically implemented in pharmacometrics.
Requires a \code{lambda} parameter.
}

To pass a custom parameter, use \code{custom} transform, and pass \code{pdist} and \code{qdist} to
that transform. See Examples.

Reminder about \code{qdist} and \code{pdist}: Consider that \code{qlogis} transforms a proportion
to a continuous, unbounded number; it is the \code{logit} transform. The \code{pdist} function
converts a continuous, unbounded number to a proportion; it is the \emph{inverse} \code{logit}
transform. Other R \code{stats} functions work similarly, and as such functions used as
\code{qdist} and \code{pdist} values are expected to act similarly.

Note that the functions used in describing associations are not real functions,
it is just the syntax for this application. Based on examples, be mindful of
where positional arguments would acceptable and where named arguments are
required. Care has been given to provide a modest amount of flexibility
with informative errors for fragile points, but not every error can be anticipated.
If this function or downstream results from it seem wrong, the association syntax
should be scrutinized. These "functions" are not processed like in \code{\link{mutate_prm}},
so (eg) \code{the2} will not be substituted for the value of \code{the2}; if
\code{lambda} is a fitted value (like \code{the2}), in that edge case the value of \code{the2} should be written
explicitly in the association formula, and if any \code{mutate_prm} changes \code{the2} then users
should be mindful of the new association needed. This may be updated in the future.

Format for associations is:
\code{LHS~fun(OMEGA, args...)}

\itemize{
\item LHS: Selector for a fixed effect parameter. Can be \verb{the\{m\}} (eg, the1),
\code{{name}} (eg, THETA1) or \code{{label}} (eg, TVCL). These should \emph{not} be quoted.
Multiple associations can be defined at once with \code{+}. Cannot be empty.
\item RHS: Should be a simple call to only one function, which should be
custom or one of the built-in distributions or \code{custom(...)}. A lot of things
can look like simple calls, so may not break immediately; keep to the described
format and everything should be fine.
\item RHS OMEGA: Selector for omega variable. Similar rules to the fixed
effect selector. Can be \verb{ome\{m\}}, \code{{name}} or \code{{label}}, limited to diagonal
elements. Should \emph{not} be quoted. \code{OMEGA} is not a named argument (\code{OMEGA={selector}}
should \strong{not} be considered valid); whatever is used as the first argument to the
"function" will be considered an OMEGA selector. \strong{NOTE}, if selecting an OMEGA parameter
by name (eg, \code{OMEGA(2,2)}), backticks (eg \code{`OMEGA(2,2)`}) must be used or else the selection will throw
an error.
\item RHS args: Applies when the distribution has extra arguments. If these
are limited to 1, can be passed by position (eg, \code{lambda} for \code{nmboxcox} and
\code{exact} for \code{log}). For \code{custom()}, \code{qdist}, \code{pdist} and any arguments needed to
pass to them should be named.
}

For the \code{nmboxcox} transformation, a lambda value (especially negative ones) may
not work well with the integration-based CV estimation. This may occur even if
the lambda is fitted and stable in that fitting, but it cannot be predicted which
ones will be affected. This note is intended to forewarn that this might happen.
}
\examples{

pheno_base \%>\%
   add_prm_association(the1~log(IIVCL),V~log(IIVV)) \%>\%
   get_prm() # get_prm is the only way to see the effect of associations

# These values are not fitted as logit-normal, but
# just to illustrate:
pheno_final \%>\%
   add_prm_association(the1~logit(IIVCL),Vpkg~logit(IIVV)) \%>\%
   get_prm()

# ... same for Box-Cox
pheno_base \%>\%
   add_prm_association(V~nmboxcox(IIVV, lambda=0.5)) \%>\%
   # Naming the argument is optional
   add_prm_association(CL~nmboxcox(IIVCL, -0.1)) \%>\%
   get_prm()

# A 'custom' use-case is when logexp, log(1+X), is
# desired but 1 is too large.
# Again, for this example, treating this like it applies here.
pheno_base \%>\%
  add_prm_association(V~custom(IIVV, qdist=function(x) log(0.001+x),
        pdist=function(x) exp(x)-0.001)) \%>\%
   get_prm()

# Dropping association is easy
bad_assoc <- pheno_final \%>\%
   add_prm_association(the1~logit(IIVCL),Vpkg~logit(IIVV))
bad_assoc

}
\references{
Prybylski, J.P. Reporting Coefficient of Variation for Logit, Box-Cox and
Other Non-log-normal Parameters. Clin Pharmacokinet 63, 133-135 (2024).
https://doi.org/10.1007/s40262-023-01343-2
}
\seealso{
\code{\link[pmxcv:dist.intcv]{dist.intcv}}
}
