% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{freq.quantile}
\alias{freq.quantile}
\title{Quantiles with a minimum frequency}
\usage{
freq.quantile(freq, min)
}
\arguments{
\item{freq}{integer; A vector of frequencies.}

\item{min}{integer; Minimum total frequency per quantile.}
}
\value{
A factor of indices is returned.
The index references the corresponding passed frequency \code{freq}.
}
\description{
This function generates quantiles with a minimum frequency.
These quantiles are formed from a vector \code{freq} of frequencies.
Each quantile then has the minimum total frequency \code{min}.
}
\details{
The frequencies \code{freq} are grouped in the order in which they
are passed as a vector.
The minimum \code{min} must be greater than \code{0}.
}
\examples{
freq <- c(1,2,3,4,5,6,7,8,9)
cumsum(freq)
(f <- freq.quantile(freq, 10))
tapply(freq, f, sum)
}
