% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_atc_code.R
\name{get_atc_code}
\alias{get_atc_code}
\title{Get ATC codes (DrecNos or MPIs)}
\usage{
get_atc_code(atc_sel, mp, thg_data, vigilyze = TRUE)
}
\arguments{
\item{atc_sel}{A named list of ATC codes. See Details.}

\item{mp}{A modified MP data.table. See \code{\link{mp_}}}

\item{thg_data}{A data.table. Correspondence between ATC codes and MedicinalProd_Id (usually, it is \code{thg})}

\item{vigilyze}{A logical. Should ATC classes be retrieved using the vigilyze style? See details}
}
\value{
A named list of integers. \strong{DrecNos} if \code{vigilyze} is set to \code{TRUE},
or \strong{MedicinalProd_Ids} if \code{vigilyze} is set to \code{FALSE}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Collect
Drug Record Numbers or MedicinalProd_Ids associated to one or more ATC classes.
}
\details{
\code{get_atc_code()} is an \emph{ID collector} function. Provide \code{atc_sel} in the same way as \code{d_sel} in \code{\link[=add_drug]{add_drug()}},
but remember to specify its method arg as \code{MedicinalProd_Id} if
\code{vigilyze} is set to \code{FALSE}.
Vigilyze style means all conditioning of drugs will be retrieved after
requesting an ATC class (i.e., drugs are identified with their DrecNos),
even if a specific conditioning is not present in the ATC class.
This is the default behavior in vigilyze.
}
\examples{
# ## Find codes associated with one or more atc classes

# First, define which atc you want to use

atc_sel <-
     rlang::list2(l03_j01 = c("L03AA", "J01CA"),
                  c09aa = c("C09AA")
     )

# You can get DrecNos for you ATCs (if vigilyze is TRUE)

atc_drecno <-
  get_atc_code(atc_sel = atc_sel,
               mp = mp_,
               thg_data = thg_,
               vigilyze = TRUE)

# Or you can get MedicinalProd_Ids (if vigilyze is FALSE)

atc_mpi <-
  get_atc_code(atc_sel = atc_sel,
               mp = mp_,
               thg_data = thg_,
               vigilyze = FALSE)
}
\seealso{
\code{\link{mp_}}, \code{\link{thg_}}, \code{\link[=add_drug]{add_drug()}}, \code{\link[=get_drecno]{get_drecno()}}
}
\keyword{atc}
\keyword{data_management}
\keyword{drug}
