% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.xtabs.R
\name{update.xtabs}
\alias{update.xtabs}
\title{Update method for a \code{xtabs} object}
\usage{
\method{update}{xtabs}(object, formula., ..., evaluate = TRUE)
}
\arguments{
\item{object}{An existing \code{"xtabs"} object}

\item{formula.}{Changes to the formula ? see
\code{\link[stats]{update.formula}} for details}

\item{\dots}{Additional arguments to the call, or arguments with changed
values.}

\item{evaluate}{If \code{TRUE}, evaluate the new call else return the call}
}
\value{
If \code{evaluate == TRUE}, the new \code{"xtabs"} object, otherwise
the updated call
}
\description{
Provides an \code{update} method for \code{"xtabs"} objects, typically by
removing terms from the formula to collapse over them.
}
\examples{

vietnam.tab <- xtabs(Freq ~ sex + year + response, data=Vietnam)

update(vietnam.tab, formula = ~ . -year)



}
\seealso{
\code{\link[stats]{update.formula}} for details on updates to model
formulae

\code{\link[base]{margin.table}} does something similar,
\code{\link{collapse.table}} collapses category levels
}
\author{
Michael Friendly
}
\keyword{models}
