% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{coeff_trussell_ti}
\alias{coeff_trussell_ti}
\title{Coefficients for the estimation of the time reference \code{t(i)}}
\format{
A data frame
}
\usage{
data(coeff_trussell_ti)
}
\description{
This is a dataset of coefficients used to derive the time reference \code{t(i)},
for values of \code{q(x)} in the TRUSSELL version of
the BRASS method, using Coale-Demeny mortality models.
}
\details{
The basic estimation equation for the Trussell method (equation 4.3) is

\deqn{t(i) = a(i) + b(i) P(1)/P(2) + c(i) P(2)/P(3)}

The names of coefficients were changed from \code{e}, \code{f}, and \code{g} to \code{a}, \code{b}, and \code{c}.
\itemize{
\item extracted from page 27, Table 5.
}
}
\references{
United Nations Population Studies (1990) Step-by-Step Guide
to the Estimation of Child Mortality No.107:1-83
(\href{https://www.un.org/en/development/desa/population/publications/pdf/mortality/stepguide_childmort.pdf}{United Nations})
}
\keyword{datasets}
